/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.value.AbstractPropertyValueModelAdapter;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionPropertyValueModelAdapter<V>
extends AbstractPropertyValueModelAdapter<V> {
    protected final CollectionValueModel<?> collectionModel;
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionPropertyValueModelAdapter(CollectionValueModel<?> collectionModel) {
        this.collectionModel = collectionModel;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                CollectionPropertyValueModelAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                CollectionPropertyValueModelAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                CollectionPropertyValueModelAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionPropertyValueModelAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    @Override
    protected void engageModel_() {
        this.collectionModel.addCollectionChangeListener("values", this.collectionChangeListener);
    }

    @Override
    protected void disengageModel_() {
        this.collectionModel.removeCollectionChangeListener("values", this.collectionChangeListener);
    }

    protected void itemsAdded(CollectionAddEvent event) {
        this.propertyChanged();
    }

    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.propertyChanged();
    }

    protected void collectionCleared(CollectionClearEvent event) {
        this.propertyChanged();
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.propertyChanged();
    }
}

