/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StringDialogField
extends DialogFieldBase
implements ISupportTextValue {
    private static final int TEXT_WIDTH_HINT = 10;
    private String _text = "";
    private Text _textControl;
    private ModifyListener _modifyListener;
    private int _numRows;
    private boolean _pending = false;

    public StringDialogField() {
        this(1);
        this._text = "";
    }

    public StringDialogField(int numRows) {
        this._numRows = numRows;
    }

    public Control[] doFillIntoGrid(FormToolkit kit, Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Control requiredLabel = this.getRequiredLabelControl(kit, parent);
        requiredLabel.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Control label = this.getLabelControl(kit, parent);
        label.setLayoutData((Object)StringDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(kit, parent);
        int heightHint = -1;
        if (this._numRows > 1) {
            heightHint = this.getDialogUnits((Control)parent).getHeight() * this._numRows;
        }
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 2, heightHint));
        return new Control[]{requiredLabel, label, text};
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    protected static GridData gridDataForText(int span, int heightHint) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.heightHint = heightHint;
        gd.horizontalSpan = span;
        gd.widthHint = 10;
        return gd;
    }

    protected static GridData gridDataForText(int span) {
        GridData gd = StringDialogField.gridDataForText(span, -1);
        return gd;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this._textControl)) {
            this._textControl.setFocus();
            this._textControl.setSelection(0, this._textControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(FormToolkit toolkit, Composite parent) {
        if (this._textControl == null || this._textControl.isDisposed()) {
            this.assertCompositeNotNull(parent);
            this._modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringDialogField.this.doModifyText(e);
                }
            };
            this._textControl = toolkit != null ? (this._numRows <= 1 ? toolkit.createText(parent, "") : toolkit.createText(parent, "", 512)) : (this._numRows <= 1 ? new Text(parent, 2052) : new Text(parent, 2624));
            this._textControl.setText(this._text);
            this._textControl.setFont(parent.getFont());
            this._textControl.addModifyListener(this._modifyListener);
            this._textControl.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    StringDialogField.this.doFocusLost(e);
                }
            });
            this._textControl.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    StringDialogField.this.doKeyReleased(e);
                }
            });
            this._textControl.setEnabled(this.isEnabled());
            this._textControl.setToolTipText(this.getToolTip());
        }
        return this._textControl;
    }

    protected void doKeyReleased(KeyEvent e) {
        if (e.character == '\r' && this._pending) {
            this._pending = false;
            this.dialogFieldApplied();
        }
    }

    protected void doFocusLost(FocusEvent e) {
        if (this._pending) {
            this._pending = false;
            this.dialogFieldApplied();
        }
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this._textControl)) {
            this._text = this._textControl.getText();
        }
        this._pending = true;
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this._textControl)) {
            this._textControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this.setTextWithoutUpdate(text);
        this.dialogFieldChangedAndApplied();
    }

    public void setTextWithoutUpdate(String text) {
        this._pending = false;
        if (text == null) {
            text = "";
        }
        this._text = text;
        if (this.isOkToUse((Control)this._textControl)) {
            this._textControl.removeModifyListener(this._modifyListener);
            this._textControl.setText(text);
            this._textControl.addModifyListener(this._modifyListener);
        }
    }

    public void handleGrabHorizontal() {
        LayoutUtil.setGrabHorizontal((Control)this._textControl, true);
    }
}

