/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogs;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.ui.dialogs.IStyleConstants;
import org.eclipse.jst.pagedesigner.ui.dialogs.StyleCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class ListPreferencePage
extends PreferencePage {
    private CSSPropertyContext _style;
    private StyleCombo _typeCombo;
    private StyleCombo _imageCombo;
    private StyleCombo _positionCombo;

    public ListPreferencePage(IDOMElement element, CSSPropertyContext style) {
        this._style = style;
        this.setTitle(DialogsMessages.getString("ListPreferencePage.Title"));
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(1808);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)data);
        Label typeLabel = new Label(top, 0);
        typeLabel.setText(DialogsMessages.getString("ListPreferencePage.Type"));
        data = new GridData(128);
        typeLabel.setLayoutData((Object)data);
        this._typeCombo = new StyleCombo(top, 0);
        this._typeCombo.setItems(IStyleConstants.LIST_TYPE);
        data = new GridData(768);
        this._typeCombo.setLayoutData(data);
        this._typeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String type = ListPreferencePage.this._typeCombo.getText();
                ListPreferencePage.this._style.setListStyleType(type);
            }
        });
        Label imageLabel = new Label(top, 0);
        imageLabel.setText(DialogsMessages.getString("ListPreferencePage.Image"));
        data = new GridData(128);
        imageLabel.setLayoutData((Object)data);
        this._imageCombo = new StyleCombo(top, 0);
        this._imageCombo.setItems(IStyleConstants.NONE);
        data = new GridData(768);
        this._imageCombo.setLayoutData(data);
        this._imageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String image = ListPreferencePage.this._imageCombo.getText();
                ListPreferencePage.this._style.setListStyleImage(image);
            }
        });
        Label positionLabel = new Label(top, 0);
        positionLabel.setText(DialogsMessages.getString("ListPreferencePage.Position"));
        data = new GridData(128);
        positionLabel.setLayoutData((Object)data);
        this._positionCombo = new StyleCombo(top, 0);
        this._positionCombo.setItems(IStyleConstants.LIST_POSITION);
        data = new GridData(768);
        this._positionCombo.setLayoutData(data);
        this._positionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String position = ListPreferencePage.this._positionCombo.getText();
                ListPreferencePage.this._style.setListStylePosition(position);
            }
        });
        this.initializeControls();
        return top;
    }

    private void initializeControls() {
        String position;
        String image;
        String type = this._style.getListStyleType();
        if (!this.isEmptyString(type)) {
            int index = this._typeCombo.indexOf(type);
            if (index != -1) {
                this._typeCombo.select(index);
            } else {
                this._typeCombo.setText(type);
            }
        }
        if (!this.isEmptyString(image = this._style.getListStyleImage())) {
            int index = this._imageCombo.indexOf(image);
            if (index != -1) {
                this._imageCombo.select(index);
            } else {
                this._imageCombo.setText(image);
            }
        }
        if (!this.isEmptyString(position = this._style.getListStylePosition())) {
            int index = this._positionCombo.indexOf(position);
            if (index != -1) {
                this._positionCombo.select(index);
            } else {
                this._positionCombo.setText(position);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getApplyButton().setVisible(false);
        this.getDefaultsButton().setVisible(false);
    }

    private boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }
}

