/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.connection;

import org.eclipse.jpt.eclipselink.core.context.persistence.connection.Connection;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStatementsPropertiesComposite<T extends Connection>
extends Pane<T> {
    public CacheStatementsPropertiesComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initializeLayout(Composite container) {
        WritablePropertyValueModel<Boolean> cacheStatementsHolder = this.buildCacheStatementsHolder();
        container = this.addSubPane(container, 3, 5, 0, 0, 0);
        this.addTriStateCheckBox(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_cacheStatementsLabel, cacheStatementsHolder, "org.eclipse.jpt.ui.persistence_connection");
        IntegerCombo<Connection> combo = this.addCacheStatementsSizeCombo(container);
        this.installControlEnabler(cacheStatementsHolder, combo);
    }

    private WritablePropertyValueModel<Boolean> buildCacheStatementsHolder() {
        return new PropertyAspectAdapter<Connection, Boolean>(this.getSubjectHolder(), new String[]{"cacheStatements"}){

            protected Boolean buildValue_() {
                return ((Connection)this.subject).getCacheStatements();
            }

            protected void setValue_(Boolean value) {
                ((Connection)this.subject).setCacheStatements(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChanged(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private IntegerCombo<Connection> addCacheStatementsSizeCombo(Composite container) {
        return new IntegerCombo<Connection>((Pane)this, container){

            protected Combo addIntegerCombo(Composite container) {
                return this.addEditableCombo(container, this.buildDefaultListHolder(), this.buildSelectedItemStringHolder(), StringConverter.Default.instance());
            }

            protected String getLabelText() {
                throw new UnsupportedOperationException();
            }

            protected String getHelpId() {
                return "org.eclipse.jpt.ui.persistence_connection";
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Connection, Integer>(this.getSubjectHolder()){

                    protected Integer buildValue_() {
                        return ((Connection)this.subject).getDefaultCacheStatementsSize();
                    }
                };
            }

            protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Connection, Integer>(this.getSubjectHolder(), new String[]{"cacheStatementsSize"}){

                    protected Integer buildValue_() {
                        return ((Connection)this.subject).getCacheStatementsSize();
                    }

                    protected void setValue_(Integer value) {
                        ((Connection)this.subject).setCacheStatementsSize(value);
                    }
                };
            }
        };
    }

    private void installControlEnabler(WritablePropertyValueModel<Boolean> cacheStatementsHolder, IntegerCombo<?> combo) {
        new PaneEnabler(cacheStatementsHolder, combo);
    }
}

