/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.NullEclipseLinkWriteTransformerColumnAnnotation;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceEclipseLinkTransformerAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkWriteTransformerAnnotation;

public final class SourceEclipseLinkWriteTransformerAnnotation
extends SourceEclipseLinkTransformerAnnotation
implements EclipseLinkWriteTransformerAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.WriteTransformer");
    private final MemberAnnotationAdapter columnAdapter;
    private ColumnAnnotation column;

    public SourceEclipseLinkWriteTransformerAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.columnAdapter = new MemberAnnotationAdapter(this.member, SourceEclipseLinkWriteTransformerAnnotation.buildColumnAnnotationAdapter(this.daa));
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.WriteTransformer";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = SourceEclipseLinkWriteTransformerAnnotation.createColumn((JavaResourceNode)this, this.member, this.daa);
            this.column.initialize(astRoot);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncColumn(astRoot);
    }

    String getTransformerClassElementName() {
        return "transformerClass";
    }

    String getMethodElementName() {
        return "method";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : new NullEclipseLinkWriteTransformerColumnAnnotation(this);
    }

    public ColumnAnnotation addColumn() {
        if (this.column != null) {
            throw new IllegalStateException("'column' element already exists: " + this.column);
        }
        this.column = SourceEclipseLinkWriteTransformerAnnotation.createColumn((JavaResourceNode)this, this.member, this.daa);
        this.column.newAnnotation();
        return this.column;
    }

    public void removeColumn() {
        if (this.column == null) {
            throw new IllegalStateException("'column' element does not exist");
        }
        this.column.removeAnnotation();
        this.column = null;
    }

    private void syncColumn(CompilationUnit astRoot) {
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.syncColumn_(null);
        } else if (this.column == null) {
            ColumnAnnotation col = SourceEclipseLinkWriteTransformerAnnotation.createColumn((JavaResourceNode)this, this.member, this.daa);
            col.initialize(astRoot);
            this.syncColumn_(col);
        } else {
            this.column.synchronizeWith(astRoot);
        }
    }

    private void syncColumn_(ColumnAnnotation astColumn) {
        ColumnAnnotation old = this.column;
        this.column = astColumn;
        this.firePropertyChanged("column", old, astColumn);
    }

    public TextRange getColumnTextRange(CompilationUnit astRoot) {
        if (this.column != null) {
            return this.column.getTextRange(astRoot);
        }
        return this.getTextRange(astRoot);
    }

    private static DeclarationAnnotationAdapter buildColumnAnnotationAdapter(DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(writeTransformerAnnotationAdapter, "column", "javax.persistence.Column", false);
    }

    private static ColumnAnnotation createColumn(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter writeTransformerAnnotationAdapter) {
        return new SourceColumnAnnotation(parent, member, SourceEclipseLinkWriteTransformerAnnotation.buildColumnAnnotationAdapter(writeTransformerAnnotationAdapter));
    }
}

