/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.context.persistence.customization.Profiler;
import org.eclipse.jpt.eclipselink.core.context.persistence.customization.Weaving;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Entity;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCustomization
extends EclipseLinkPersistenceUnitProperties
implements Customization {
    private Boolean throwExceptions;
    private Weaving weaving;
    private Boolean weavingLazy;
    private Boolean weavingChangeTracking;
    private Boolean weavingFetchGroups;
    private Boolean weavingInternal;
    private Boolean weavingEager;
    private Boolean validationOnly;
    private Boolean validateSchema;
    private List<String> sessionCustomizers;
    private String profiler;
    private String exceptionHandler;
    private List<Entity> entities;

    public EclipseLinkCustomization(PersistenceUnit parent) {
        super(parent);
    }

    protected void initializeProperties() {
        this.entities = new ArrayList<Entity>();
        this.throwExceptions = this.getBooleanValue("eclipselink.orm.throw.exceptions");
        this.weaving = (Weaving)this.getEnumValue("eclipselink.weaving", Weaving.values());
        this.weavingLazy = this.getBooleanValue("eclipselink.weaving.lazy");
        this.weavingChangeTracking = this.getBooleanValue("eclipselink.weaving.changetracking");
        this.weavingFetchGroups = this.getBooleanValue("eclipselink.weaving.fetchgroups");
        this.weavingInternal = this.getBooleanValue("eclipselink.weaving.internal");
        this.weavingEager = this.getBooleanValue("eclipselink.weaving.eager");
        this.validationOnly = this.getBooleanValue("eclipselink.validation-only");
        this.validateSchema = this.getBooleanValue("eclipselink.orm.validate.schema");
        this.initializeSessionCustomizersFromPersistenceUnit();
        Set<PersistenceUnit.Property> properties = this.getPropertiesSetWithPrefix("eclipselink.descriptor.customizer.");
        this.initializeEntitiesCustomizerClass(properties);
        this.profiler = this.getProfilerPropertyValue();
        this.exceptionHandler = this.getStringValue("eclipselink.exception-handler");
    }

    private void initializeSessionCustomizersFromPersistenceUnit() {
        Set<PersistenceUnit.Property> properties = this.getPropertiesSetWithPrefix("eclipselink.session.customizer");
        this.sessionCustomizers = new ArrayList<String>(properties.size());
        this.initializeSessionCustomizersWith(properties);
    }

    private void initializeSessionCustomizersWith(Set<PersistenceUnit.Property> properties) {
        for (PersistenceUnit.Property property : properties) {
            this.sessionCustomizers.add(property.getValue());
        }
    }

    private void initializeEntitiesCustomizerClass(Set<PersistenceUnit.Property> descriptorCustomizerProperties) {
        for (PersistenceUnit.Property descriptorCustomizerProperty : descriptorCustomizerProperties) {
            this.setEntityDescriptorCustomizerOf(descriptorCustomizerProperty);
        }
    }

    private String getProfilerPropertyValue() {
        String value = this.getStringValue("eclipselink.profiler");
        if (value == null) {
            return null;
        }
        Profiler standardProfiler = (Profiler)this.getEnumValue("eclipselink.profiler", Profiler.values());
        return standardProfiler == null ? value : EclipseLinkCustomization.getPropertyStringValueOf((Object)((Object)standardProfiler));
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.orm.throw.exceptions")) {
            this.throwExceptionsChanged(newValue);
        } else if (propertyName.equals("eclipselink.weaving")) {
            this.weavingChanged(newValue);
        } else if (propertyName.equals("eclipselink.weaving.lazy")) {
            this.weavingLazyChanged(newValue);
        } else if (propertyName.equals("eclipselink.weaving.changetracking")) {
            this.weavingChangeTrackingChanged(newValue);
        } else if (propertyName.equals("eclipselink.weaving.fetchgroups")) {
            this.weavingFetchGroupsChanged(newValue);
        } else if (propertyName.equals("eclipselink.weaving.internal")) {
            this.weavingInternalChanged(newValue);
        } else if (propertyName.equals("eclipselink.weaving.eager")) {
            this.weavingEagerChanged(newValue);
        } else if (propertyName.equals("eclipselink.validation-only")) {
            this.validationOnlyChanged(newValue);
        } else if (propertyName.equals("eclipselink.orm.validate.schema")) {
            this.validateSchemaChanged(newValue);
        } else if (propertyName.equals("eclipselink.session.customizer")) {
            this.sessionCustomizersChanged();
        } else if (propertyName.startsWith("eclipselink.descriptor.customizer.")) {
            this.descriptorCustomizerChanged(propertyName, newValue);
        } else if (propertyName.equals("eclipselink.profiler")) {
            this.profilerChanged(newValue);
        } else if (propertyName.equals("eclipselink.exception-handler")) {
            this.exceptionHandlerChanged(newValue);
        }
    }

    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.orm.throw.exceptions")) {
            this.throwExceptionsChanged(null);
        } else if (propertyName.equals("eclipselink.weaving")) {
            this.weavingChanged(null);
        } else if (propertyName.equals("eclipselink.weaving.lazy")) {
            this.weavingLazyChanged(null);
        } else if (propertyName.equals("eclipselink.weaving.changetracking")) {
            this.weavingChangeTrackingChanged(null);
        } else if (propertyName.equals("eclipselink.weaving.fetchgroups")) {
            this.weavingFetchGroupsChanged(null);
        } else if (propertyName.equals("eclipselink.weaving.internal")) {
            this.weavingInternalChanged(null);
        } else if (propertyName.equals("eclipselink.weaving.eager")) {
            this.weavingEagerChanged(null);
        } else if (propertyName.equals("eclipselink.validation-only")) {
            this.validationOnlyChanged(null);
        } else if (propertyName.equals("eclipselink.orm.validate.schema")) {
            this.validateSchemaChanged(null);
        } else if (propertyName.equals("eclipselink.session.customizer")) {
            this.sessionCustomizersChanged();
        } else if (propertyName.startsWith("eclipselink.descriptor.customizer.")) {
            this.descriptorCustomizerChanged(propertyName, null);
        } else if (propertyName.equals("eclipselink.profiler")) {
            this.profilerChanged(null);
        } else if (propertyName.equals("eclipselink.exception-handler")) {
            this.exceptionHandlerChanged(null);
        }
    }

    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.orm.throw.exceptions", "throwExceptions");
        propertyNames.put("eclipselink.weaving", "weaving");
        propertyNames.put("eclipselink.weaving.lazy", "weavingLazy");
        propertyNames.put("eclipselink.weaving.changetracking", "weavingChangeTracking");
        propertyNames.put("eclipselink.weaving.fetchgroups", "weavingFetchGroups");
        propertyNames.put("eclipselink.weaving.internal", "weavingInternal");
        propertyNames.put("eclipselink.weaving.eager", "weavingEager");
        propertyNames.put("eclipselink.validation-only", "validationOnly");
        propertyNames.put("eclipselink.orm.validate.schema", "validateSchema");
        propertyNames.put("eclipselink.session.customizer", "sessionCustomizer");
        propertyNames.put("eclipselink.profiler", "profiler");
        propertyNames.put("eclipselink.exception-handler", "exceptionHandler");
    }

    public boolean itemIsProperty(PersistenceUnit.Property item) {
        boolean isProperty = super.itemIsProperty(item);
        if (!isProperty && item.getName() != null && item.getName().startsWith("eclipselink.descriptor.customizer.")) {
            return true;
        }
        return isProperty;
    }

    public String propertyIdOf(PersistenceUnit.Property property) {
        try {
            return super.propertyIdOf(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (property.getName().startsWith("eclipselink.descriptor.customizer.")) {
                return "descriptorCustomizer";
            }
            throw new IllegalArgumentException("Illegal property: " + property);
        }
    }

    @Override
    public Entity addEntity(String entityName) {
        if (this.entityExists(entityName)) {
            throw new IllegalStateException("Entity " + entityName + " already exists.");
        }
        Entity newEntity = this.buildEntity(entityName);
        this.entities.add(newEntity);
        this.fireListChanged("entities", this.entities);
        return newEntity;
    }

    @Override
    public void removeEntity(String entityName) {
        if (!this.entityExists(entityName)) {
            return;
        }
        Entity entity = this.getEntityNamed(entityName);
        this.clearEntity(entity);
        this.removeEntity(entity);
    }

    @Override
    public Boolean getThrowExceptions() {
        return this.throwExceptions;
    }

    @Override
    public void setThrowExceptions(Boolean newThrowExceptions) {
        Boolean old = this.throwExceptions;
        this.throwExceptions = newThrowExceptions;
        this.putProperty("throwExceptions", newThrowExceptions);
        this.firePropertyChanged("throwExceptions", old, newThrowExceptions);
    }

    private void throwExceptionsChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.throwExceptions;
        this.throwExceptions = newValue;
        this.firePropertyChanged("throwExceptions", old, newValue);
    }

    @Override
    public Boolean getDefaultThrowExceptions() {
        return DEFAULT_THROW_EXCEPTIONS;
    }

    @Override
    public Boolean getWeavingLazy() {
        return this.weavingLazy;
    }

    @Override
    public void setWeavingLazy(Boolean newWeavingLazy) {
        Boolean old = this.weavingLazy;
        this.weavingLazy = newWeavingLazy;
        this.putProperty("weavingLazy", newWeavingLazy);
        this.firePropertyChanged("weavingLazy", old, newWeavingLazy);
    }

    private void weavingLazyChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.weavingLazy;
        this.weavingLazy = newValue;
        this.firePropertyChanged("weavingLazy", old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingLazy() {
        return DEFAULT_WEAVING_LAZY;
    }

    @Override
    public Boolean getWeavingChangeTracking() {
        return this.weavingChangeTracking;
    }

    @Override
    public void setWeavingChangeTracking(Boolean newWeavingChangeTracking) {
        Boolean old = this.weavingChangeTracking;
        this.weavingChangeTracking = newWeavingChangeTracking;
        this.putProperty("weavingChangeTracking", newWeavingChangeTracking);
        this.firePropertyChanged("weavingChangeTracking", old, newWeavingChangeTracking);
    }

    private void weavingChangeTrackingChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.weavingChangeTracking;
        this.weavingChangeTracking = newValue;
        this.firePropertyChanged("weavingChangeTracking", old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingChangeTracking() {
        return DEFAULT_WEAVING_CHANGE_TRACKING;
    }

    @Override
    public Boolean getWeavingFetchGroups() {
        return this.weavingFetchGroups;
    }

    @Override
    public void setWeavingFetchGroups(Boolean newWeavingFetchGroups) {
        Boolean old = this.weavingFetchGroups;
        this.weavingFetchGroups = newWeavingFetchGroups;
        this.putProperty("weavingFetchGroups", newWeavingFetchGroups);
        this.firePropertyChanged("weavingFetchGroups", old, newWeavingFetchGroups);
    }

    private void weavingFetchGroupsChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.weavingFetchGroups;
        this.weavingFetchGroups = newValue;
        this.firePropertyChanged("weavingFetchGroups", old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingFetchGroups() {
        return DEFAULT_WEAVING_FETCH_GROUPS;
    }

    @Override
    public Boolean getWeavingInternal() {
        return this.weavingInternal;
    }

    @Override
    public void setWeavingInternal(Boolean newWeavingInternal) {
        Boolean old = this.weavingInternal;
        this.weavingInternal = newWeavingInternal;
        this.putProperty("weavingInternal", newWeavingInternal);
        this.firePropertyChanged("weavingInternal", old, newWeavingInternal);
    }

    private void weavingInternalChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.weavingInternal;
        this.weavingInternal = newValue;
        this.firePropertyChanged("weavingInternal", old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingInternal() {
        return DEFAULT_WEAVING_INTERNAL;
    }

    @Override
    public Boolean getWeavingEager() {
        return this.weavingEager;
    }

    @Override
    public void setWeavingEager(Boolean newWeavingEager) {
        Boolean old = this.weavingEager;
        this.weavingEager = newWeavingEager;
        this.putProperty("weavingEager", newWeavingEager);
        this.firePropertyChanged("weavingEager", old, newWeavingEager);
    }

    private void weavingEagerChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.weavingEager;
        this.weavingEager = newValue;
        this.firePropertyChanged("weavingEager", old, newValue);
    }

    @Override
    public Boolean getDefaultWeavingEager() {
        return DEFAULT_WEAVING_EAGER;
    }

    @Override
    public Boolean getValidationOnly() {
        return this.validationOnly;
    }

    @Override
    public void setValidationOnly(Boolean newValidationOnly) {
        Boolean old = this.validationOnly;
        this.validationOnly = newValidationOnly;
        this.putProperty("validationOnly", newValidationOnly);
        this.firePropertyChanged("validationOnly", old, newValidationOnly);
    }

    private void validationOnlyChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.validationOnly;
        this.validationOnly = newValue;
        this.firePropertyChanged("validationOnly", old, newValue);
    }

    @Override
    public Boolean getDefaultValidationOnly() {
        return DEFAULT_VALIDATION_ONLY;
    }

    @Override
    public Boolean getValidateSchema() {
        return this.validateSchema;
    }

    @Override
    public void setValidateSchema(Boolean newValidateSchema) {
        Boolean old = this.validateSchema;
        this.validateSchema = newValidateSchema;
        this.putProperty("validateSchema", newValidateSchema);
        this.firePropertyChanged("validateSchema", old, newValidateSchema);
    }

    private void validateSchemaChanged(String stringValue) {
        Boolean newValue = EclipseLinkCustomization.getBooleanValueOf((String)stringValue);
        Boolean old = this.validateSchema;
        this.validateSchema = newValue;
        this.firePropertyChanged("validateSchema", old, newValue);
    }

    @Override
    public Boolean getDefaultValidateSchema() {
        return DEFAULT_VALIDATE_SCHEMA;
    }

    @Override
    public ListIterator<String> sessionCustomizers() {
        return new CloneListIterator(this.sessionCustomizers);
    }

    @Override
    public int sessionCustomizersSize() {
        return this.sessionCustomizers.size();
    }

    @Override
    public boolean sessionCustomizerExists(String sessionCustomizerClassName) {
        for (String sessionCustomizer : this.sessionCustomizers) {
            if (!sessionCustomizer.equals(sessionCustomizerClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String addSessionCustomizer(String newSessionCustomizerClassName) {
        if (!this.sessionCustomizerExists(newSessionCustomizerClassName)) {
            this.sessionCustomizers.add(newSessionCustomizerClassName);
            this.putProperty("sessionCustomizer", newSessionCustomizerClassName, true);
            this.fireListChanged("sessionCustomizers", this.sessionCustomizers);
            return newSessionCustomizerClassName;
        }
        return null;
    }

    @Override
    public void removeSessionCustomizer(String className) {
        if (this.removeSessionCustomizer_(className) != null) {
            this.removeProperty("sessionCustomizer", className);
            this.fireListChanged("sessionCustomizers", this.sessionCustomizers);
        }
    }

    private String removeSessionCustomizer_(String className) {
        ListIterator<String> i = this.sessionCustomizers();
        while (i.hasNext()) {
            String sessionCustomizer = i.next();
            if (!sessionCustomizer.equals(className)) continue;
            this.sessionCustomizers.remove(sessionCustomizer);
            return sessionCustomizer;
        }
        return null;
    }

    private void sessionCustomizersChanged() {
        this.initializeSessionCustomizersFromPersistenceUnit();
        this.fireListChanged("sessionCustomizers", this.sessionCustomizers);
    }

    @Override
    public Weaving getWeaving() {
        return this.weaving;
    }

    @Override
    public void setWeaving(Weaving newWeaving) {
        Weaving old = this.weaving;
        this.weaving = newWeaving;
        this.putProperty("weaving", (Object)newWeaving);
        this.firePropertyChanged("weaving", (Object)old, (Object)newWeaving);
    }

    private void weavingChanged(String stringValue) {
        Weaving newValue = (Weaving)EclipseLinkCustomization.getEnumValueOf((String)stringValue, (Enum[])Weaving.values());
        Weaving old = this.weaving;
        this.weaving = newValue;
        this.firePropertyChanged("weaving", (Object)old, (Object)newValue);
    }

    @Override
    public Weaving getDefaultWeaving() {
        return DEFAULT_WEAVING;
    }

    @Override
    public String getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(String newExceptionHandler) {
        String old = this.exceptionHandler;
        this.exceptionHandler = newExceptionHandler;
        this.putProperty("exceptionHandler", newExceptionHandler);
        this.firePropertyChanged("exceptionHandler", old, newExceptionHandler);
    }

    private void exceptionHandlerChanged(String newValue) {
        String old = this.exceptionHandler;
        this.exceptionHandler = newValue;
        this.firePropertyChanged("exceptionHandler", old, newValue);
    }

    @Override
    public String getDefaultExceptionHandler() {
        return DEFAULT_EXCEPTION_HANDLER;
    }

    @Override
    public String getDescriptorCustomizerOf(String entityName) {
        Entity entity = this.getEntityNamed(entityName);
        return entity == null ? null : entity.getDescriptorCustomizer();
    }

    @Override
    public void setDescriptorCustomizerOf(String entityName, String newDescriptorCustomizer) {
        Entity old = this.setEntityDescriptorCustomizerOf(entityName, newDescriptorCustomizer);
        this.putStringValue("eclipselink.descriptor.customizer.", entityName, newDescriptorCustomizer, false);
        this.firePropertyChanged("descriptorCustomizer", old, this.getEntityNamed(entityName));
    }

    private void descriptorCustomizerChanged(String propertyName, String stringValue) {
        String entityName = this.extractEntityNameOf(propertyName);
        if (!StringTools.stringIsEmpty((String)entityName)) {
            Entity old = this.setEntityDescriptorCustomizerOf(entityName, stringValue);
            this.firePropertyChanged("descriptorCustomizer", old, this.getEntityNamed(entityName));
        }
    }

    @Override
    public String getDefaultDescriptorCustomizer() {
        return DEFAULT_DESCRIPTOR_CUSTOMIZER;
    }

    private Entity setEntityDescriptorCustomizerOf(String entityName, String descriptorCustomizerClassName) {
        if (!this.entityExists(entityName) && StringTools.stringIsEmpty((String)descriptorCustomizerClassName)) {
            return null;
        }
        Entity entity = this.entityExists(entityName) ? this.getEntityNamed(entityName) : this.addEntity(entityName);
        return this.setEntityDescriptorCustomizerOf(entity, descriptorCustomizerClassName);
    }

    private Entity setEntityDescriptorCustomizerOf(Entity entity, String descriptorCustomizerClassName) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        Entity old = entity.clone();
        entity.setDescriptorCustomizer(descriptorCustomizerClassName);
        return old;
    }

    private Entity setEntityDescriptorCustomizerOf(PersistenceUnit.Property descriptorCustomizerProperty) {
        String entityName = this.extractEntityNameOf(descriptorCustomizerProperty);
        if (StringTools.stringIsEmpty((String)entityName)) {
            return null;
        }
        return this.setEntityDescriptorCustomizerOf(entityName, descriptorCustomizerProperty.getValue());
    }

    @Override
    public String getProfiler() {
        return this.profiler;
    }

    @Override
    public void setProfiler(Profiler newProfiler) {
        if (newProfiler == null) {
            this.setProfiler_(null);
            return;
        }
        this.setProfiler_(EclipseLinkCustomization.getPropertyStringValueOf((Object)((Object)newProfiler)));
    }

    @Override
    public void setProfiler(String newProfiler) {
        if (newProfiler == null) {
            this.setProfiler_(null);
            return;
        }
        Profiler p = Profiler.getProfilerFor(newProfiler);
        if (p == null) {
            this.setProfiler_(newProfiler);
        } else {
            this.setProfiler(p);
        }
    }

    private void setProfiler_(String newProfiler) {
        String old = this.profiler;
        this.profiler = newProfiler;
        this.putProperty("profiler", newProfiler);
        this.firePropertyChanged("profiler", old, newProfiler);
    }

    private void profilerChanged(String newValue) {
        String old = this.profiler;
        this.profiler = newValue;
        this.firePropertyChanged("profiler", old, newValue);
    }

    @Override
    public String getDefaultProfiler() {
        return DEFAULT_PROFILER;
    }

    private void clearEntity(Entity entity) {
        if (entity.isEmpty()) {
            return;
        }
        String entityName = entity.getName();
        this.setDescriptorCustomizerOf(entityName, null);
    }

    private Entity getEntityNamed(String name) {
        for (Entity entity : this.entities) {
            if (!entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    private Entity buildEntity(String name) {
        return new Entity(this, name);
    }

    private void removeEntity(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        this.entities.remove(entity);
        this.fireListChanged("entities", this.entities);
    }

    @Override
    public boolean entityExists(String name) {
        for (Entity entity : this.entities) {
            if (!entity.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ListIterator<Entity> entities() {
        return new CloneListIterator(this.entities);
    }

    @Override
    public Iterator<String> entityNames() {
        return new TransformationIterator<Entity, String>(this.entities()){

            protected String transform(Entity entity) {
                return entity.getName();
            }
        };
    }

    @Override
    public int entitiesSize() {
        return this.entities.size();
    }
}

