/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.launching.config.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchProperties {
    private final Map<String, String> properties = new HashMap<String, String>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public String toXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element propertysEl = doc.createElement("Properties");
        doc.appendChild(propertysEl);
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String name = property.getKey();
            String value = property.getValue();
            Element propertyEl = doc.createElement("Property");
            propertyEl.setAttribute("name", name);
            propertyEl.setAttribute("value", value);
            propertysEl.appendChild(propertyEl);
        }
        return PreferenceUtil.serializeDocument((Document)doc);
    }

    public static LaunchProperties fromXML(InputStream inputStream) throws CoreException {
        Document doc = PreferenceUtil.getDocument((InputStream)inputStream);
        LaunchProperties pdef = new LaunchProperties();
        Element propertysEl = doc.getDocumentElement();
        NodeList propertyEls = propertysEl.getElementsByTagName("Property");
        int i = 0;
        while (i < propertyEls.getLength()) {
            Element propertyEl = (Element)propertyEls.item(i);
            String name = propertyEl.getAttribute("name");
            String value = propertyEl.getAttribute("value");
            pdef.setProperty(name, value);
            ++i;
        }
        return pdef;
    }
}

