/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import java.util.ArrayList;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.common.AbstractAnnotationFactory;
import org.eclipse.jst.jee.model.internal.common.Result;

public class WebAnnotationFactory
extends AbstractAnnotationFactory {
    private static final String NAME = "name";
    private static final String FILTER_NAME = "filterName";
    private static final String DESCRIPTION = "description";
    private static final String EJB = "EJB";
    private static final String RUN_AS = "RunAs";
    private static final String RESOURCE = "Resource";
    private static final String RESOURCES = "Resources";
    private static final String DECLARE_ROLES = "DeclareRoles";
    private static final String URL_PATTERNS_NAME = "urlPatterns";
    private static final String WEB_SERVLET = "WebServlet";
    private static final String WEB_SERVLET_FQ = "javax.servlet.annotation.WebServlet";
    private static final String WEB_LISTENER = "WebListener";
    private static final String WEB_LISTENER_FQ = "javax.servlet.annotation.WebListener";
    private static final String WEB_FILTER = "WebFilter";
    private static final String WEB_FILTER_FQ = "javax.servlet.annotation.WebFilter";

    private WebAnnotationFactory() {
    }

    public static WebAnnotationFactory createFactory() {
        return new WebAnnotationFactory();
    }

    public Result createServlet(IType rootType, String servletName) throws JavaModelException {
        Result result = new Result();
        Servlet servlet = WebFactory.eINSTANCE.createServlet();
        servlet.setServletName(servletName);
        servlet.setServletClass(rootType.getFullyQualifiedName());
        result.setMainObject((JavaEEObject)servlet);
        this.processCommonAnnotation(result, (JavaEEObject)servlet, rootType);
        this.processTypeAnnotations(result, rootType);
        this.processMethodAnnotations(result, rootType);
        this.processFieldAnnotations(result, rootType);
        return result;
    }

    public Result createListener(IType rootType) throws JavaModelException {
        Result result = new Result();
        Listener listener = JavaeeFactory.eINSTANCE.createListener();
        listener.setListenerClass(rootType.getFullyQualifiedName());
        result.setMainObject((JavaEEObject)listener);
        this.processCommonAnnotation(result, (JavaEEObject)listener, rootType);
        this.processTypeAnnotations(result, rootType);
        this.processMethodAnnotations(result, rootType);
        this.processFieldAnnotations(result, rootType);
        return result;
    }

    public Result createFilter(IType rootType, String filterName) throws JavaModelException {
        Result result = new Result();
        Filter filter = WebFactory.eINSTANCE.createFilter();
        filter.setFilterName(filterName);
        filter.setFilterClass(rootType.getFullyQualifiedName());
        result.setMainObject((JavaEEObject)filter);
        this.processCommonAnnotation(result, (JavaEEObject)filter, rootType);
        this.processTypeAnnotations(result, rootType);
        this.processMethodAnnotations(result, rootType);
        this.processFieldAnnotations(result, rootType);
        return result;
    }

    private void processCommonAnnotation(Result result, JavaEEObject artifact, IType rootType) throws JavaModelException {
        IAnnotation[] iAnnotationArray = rootType.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Description description;
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationName = annotation.getElementName();
            IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
            String name = (String)this.getAnnotatedValue(NAME, memberValuePairs);
            String filterName = (String)this.getAnnotatedValue(FILTER_NAME, memberValuePairs);
            String descr = (String)this.getAnnotatedValue(DESCRIPTION, memberValuePairs);
            if (WEB_SERVLET.equals(annotationName) || WEB_SERVLET_FQ.equals(annotationName)) {
                Servlet servlet = (Servlet)artifact;
                if (name != null) {
                    servlet.setServletName(name);
                } else if (servlet.getServletName() == null) {
                    servlet.setServletName(rootType.getElementName());
                }
                if (descr != null) {
                    description = JavaeeFactory.eINSTANCE.createDescription();
                    description.setValue(descr);
                    servlet.getDescriptions().add(description);
                }
                this.processUrlMapping(result, annotation, (JavaEEObject)servlet);
            } else if (WEB_FILTER.equals(annotationName) || WEB_FILTER_FQ.equals(annotationName)) {
                Filter filter = (Filter)artifact;
                if (filterName != null) {
                    filter.setFilterName(filterName);
                } else if (filter.getFilterName() == null) {
                    filter.setFilterName(rootType.getElementName());
                }
                if (descr != null) {
                    description = JavaeeFactory.eINSTANCE.createDescription();
                    description.setValue(descr);
                    filter.getDescriptions().add(description);
                }
                this.processUrlMapping(result, annotation, (JavaEEObject)filter);
            } else if (WEB_LISTENER.equals(annotationName) || WEB_LISTENER_FQ.equals(annotationName)) {
                Listener listener = (Listener)artifact;
                description = JavaeeFactory.eINSTANCE.createDescription();
                if (listener.getListenerClass() == null) {
                    listener.setListenerClass(rootType.getFullyQualifiedName());
                }
                if (descr != null) {
                    description.setValue(descr);
                    listener.getDescriptions().add(description);
                }
            }
            ++n2;
        }
    }

    private void processTypeAnnotations(Result result, IType type) throws JavaModelException {
        JavaEEObject mainObject = result.getMainObject();
        boolean isServlet = Servlet.class.isInstance(mainObject);
        IAnnotation[] iAnnotationArray = type.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList resourceRefs;
            IAnnotation annotation = iAnnotationArray[n2];
            String annotationName = annotation.getElementName();
            if (isServlet && DECLARE_ROLES.equals(annotationName)) {
                ArrayList refs = new ArrayList();
                this.processDeclareRoles(result, refs, annotation, type);
                ((Servlet)mainObject).getSecurityRoleRefs().addAll(refs);
            } else if (RESOURCES.equals(annotationName)) {
                resourceRefs = new ArrayList(2);
                this.processResourcesAnnotation(annotation, resourceRefs, type, result.getDependedTypes());
                result.getAdditional().addAll(resourceRefs);
            } else if (RESOURCE.equals(annotationName)) {
                resourceRefs = new ArrayList(2);
                this.processResourceRefAnnotation(annotation, resourceRefs, (IMember)type, result.getDependedTypes());
                result.getAdditional().addAll(resourceRefs);
            } else if (isServlet && RUN_AS.equals(annotationName)) {
                RunAs runAs = JavaeeFactory.eINSTANCE.createRunAs();
                this.processRunAs(annotation, runAs);
                ((Servlet)mainObject).setRunAs(runAs);
            }
            ++n2;
        }
    }

    private void processFieldAnnotations(Result result, IType type) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            IAnnotation[] iAnnotationArray = field.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                this.processMemberAnnotations(result, (IMember)field, annotation);
                ++n4;
            }
            ++n2;
        }
    }

    private void processMethodAnnotations(Result result, IType type) throws JavaModelException {
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            IAnnotation[] iAnnotationArray = method.getAnnotations();
            int n3 = iAnnotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAnnotation annotation = iAnnotationArray[n4];
                this.processMemberAnnotations(result, (IMember)method, annotation);
                ++n4;
            }
            ++n2;
        }
    }

    private void processMemberAnnotations(Result result, IMember member, IAnnotation annotation) throws JavaModelException {
        String annotationName = annotation.getElementName();
        if (EJB.equals(annotationName)) {
            ArrayList refs = new ArrayList(1);
            this.processEjbAnnotation(annotation, refs, member, result.getDependedTypes());
            result.getAdditional().addAll(refs);
        } else if (RESOURCE.equals(annotationName)) {
            ArrayList refs = new ArrayList(1);
            this.processResourceRefAnnotation(annotation, refs, member, result.getDependedTypes());
            result.getAdditional().addAll(refs);
        }
    }

    private void processUrlMapping(Result result, IAnnotation annotation, JavaEEObject artifact) throws JavaModelException {
        IMemberValuePair[] pairs = annotation.getMemberValuePairs();
        Object values = this.getAnnotatedValue(URL_PATTERNS_NAME, pairs);
        if (values == null) {
            values = this.getAnnotatedValue("value", pairs);
        }
        if (values == null) {
            return;
        }
        if (Servlet.class.isInstance(artifact)) {
            String servletName = ((Servlet)artifact).getServletName();
            ServletMapping mapping = WebFactory.eINSTANCE.createServletMapping();
            mapping.setServletName(servletName);
            if (!WebAnnotationFactory.isArrayOfObject((Object)values)) {
                this.transformToMapping(mapping, values);
            } else {
                Object[] objectArray = (Object[])values;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object urlPattern = objectArray[n2];
                    this.transformToMapping(mapping, urlPattern);
                    ++n2;
                }
            }
            result.getAdditional().add(mapping);
        } else if (Filter.class.isInstance(artifact)) {
            String filterName = ((Filter)artifact).getFilterName();
            FilterMapping mapping = WebFactory.eINSTANCE.createFilterMapping();
            mapping.setFilterName(filterName);
            if (!WebAnnotationFactory.isArrayOfObject((Object)values)) {
                UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPatternType.setValue((String)values);
                mapping.getUrlPatterns().add(urlPatternType);
            } else {
                Object[] objectArray = (Object[])values;
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object urlPattern = objectArray[n3];
                    UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
                    urlPatternType.setValue((String)urlPattern);
                    mapping.getUrlPatterns().add(urlPatternType);
                    ++n3;
                }
            }
            result.getAdditional().add(mapping);
        }
    }

    private void transformToMapping(ServletMapping mapping, Object urlPattern) {
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType.setValue((String)urlPattern);
        mapping.getUrlPatterns().add(urlPatternType);
    }
}

