/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.resources;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.designtime.internal.resources.IJarBasedJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifier;

public class JarBasedJSFResource
extends JSFResource
implements IJarBasedJSFResource {
    private final URL _jarURL;

    public JarBasedJSFResource(ResourceIdentifier id, URL jarURL, ContentTypeResolver contentTypeResolver) {
        super(id, contentTypeResolver);
        this._jarURL = jarURL;
    }

    public URL getJarURL() {
        return this._jarURL;
    }

    public String getJarEntryName() {
        return String.format("META-INF/resources/%s", this.getId().toString());
    }

    private ZipEntry getZipEntry(JarFile jarFile) {
        return jarFile.getEntry(this.getJarEntryName());
    }

    public boolean isAccessible() {
        JarFile jarFile = null;
        jarFile = this.getJarFile();
        if (jarFile != null) {
            ZipEntry entry = this.getZipEntry(jarFile);
            boolean bl = entry != null;
            return bl;
        }
        return false;
    }

    private JarFile getJarFile() {
        try {
            URLConnection connection = this._jarURL.openConnection();
            connection.connect();
            if (connection instanceof JarURLConnection) {
                return ((JarURLConnection)connection).getJarFile();
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

