/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpointParticipant;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;

public class BreakpointParticipantManager {
    static final IJavaScriptBreakpointParticipant[] NO_PARTICIPANTS = new IJavaScriptBreakpointParticipant[0];
    public static final String ALL = "*";
    public static final String FUNCTION = "function";
    public static final String LINE = "line";
    public static final String SCRIPT = "script";
    private Map participants = null;

    IJavaScriptBreakpointParticipant[] getParticipants(String kind) {
        this.initialize();
        ArrayList parts = (ArrayList)this.participants.get(kind);
        if (parts != null) {
            return parts.toArray(new IJavaScriptBreakpointParticipant[parts.size()]);
        }
        return NO_PARTICIPANTS;
    }

    public IJavaScriptBreakpointParticipant[] getParticipants(IJavaScriptBreakpoint breakpoint) {
        this.initialize();
        ArrayList parts = new ArrayList();
        ArrayList existing = (ArrayList)this.participants.get(ALL);
        if (existing != null) {
            parts.addAll(existing);
        }
        if (breakpoint instanceof IJavaScriptFunctionBreakpoint) {
            existing = (ArrayList)this.participants.get(FUNCTION);
            if (existing != null) {
                parts.addAll(existing);
            }
        } else if (breakpoint instanceof IJavaScriptLoadBreakpoint) {
            existing = (ArrayList)this.participants.get(SCRIPT);
            if (existing != null) {
                parts.addAll(existing);
            }
        } else if (breakpoint instanceof IJavaScriptLineBreakpoint && (existing = (ArrayList)this.participants.get(LINE)) != null) {
            parts.addAll(existing);
        }
        if (parts.size() < 1) {
            return NO_PARTICIPANTS;
        }
        return parts.toArray(new IJavaScriptBreakpointParticipant[parts.size()]);
    }

    public void addParticipant(String kind, IJavaScriptBreakpointParticipant participant) {
        this.initialize();
        Assert.isNotNull((Object)kind);
        ArrayList<IJavaScriptBreakpointParticipant> parts = (ArrayList<IJavaScriptBreakpointParticipant>)this.participants.get(kind);
        if (parts == null) {
            parts = new ArrayList<IJavaScriptBreakpointParticipant>();
            this.participants.put(kind, parts);
        }
        if (!parts.contains(participant)) {
            parts.add(participant);
        }
    }

    private synchronized void initialize() {
        if (this.participants == null) {
            this.participants = Collections.synchronizedMap(new HashMap());
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.jsdt.debug.core", "breakpointParticipants");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            String kind = null;
            ArrayList<Participant> parts = null;
            int i = 0;
            while (i < elements.length) {
                kind = elements[i].getAttribute("kind");
                parts = (ArrayList<Participant>)this.participants.get(kind);
                if (parts == null) {
                    parts = new ArrayList<Participant>();
                    this.participants.put(kind, parts);
                }
                parts.add(new Participant(elements[i]));
                ++i;
            }
        }
    }

    public void dispose() {
        if (this.participants != null) {
            this.participants.clear();
            this.participants = null;
        }
    }

    class Participant
    implements IJavaScriptBreakpointParticipant {
        private IConfigurationElement element = null;
        private IJavaScriptBreakpointParticipant delegate = null;

        public Participant(IConfigurationElement element) {
            this.element = element;
        }

        public int breakpointHit(IJavaScriptThread thread, IJavaScriptBreakpoint breakpoint) {
            IJavaScriptBreakpointParticipant part = this.getDelegate();
            if (part != null) {
                return part.breakpointHit(thread, breakpoint);
            }
            return 0;
        }

        synchronized IJavaScriptBreakpointParticipant getDelegate() {
            if (this.delegate == null) {
                try {
                    this.delegate = (IJavaScriptBreakpointParticipant)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    JavaScriptDebugPlugin.log(e);
                }
            }
            return this.delegate;
        }

        public int scriptLoaded(IJavaScriptThread thread, ScriptReference script, IJavaScriptBreakpoint breakpoint) {
            IJavaScriptBreakpointParticipant part = this.getDelegate();
            if (part != null) {
                return part.scriptLoaded(thread, script, breakpoint);
            }
            return 0;
        }
    }
}

