/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.undoextension;

import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viplugineclipse.EditorImplementation;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;

class ViUndoManager
implements com.mbartl.viimplementation.interfaces.IUndoManager {
    private final IUndoManager _undoManager;
    private final ITextViewer _viewer;
    private final EditorImplementation _editor;

    public ViUndoManager(EditorImplementation editor, ITextViewer viewer) {
        this._viewer = viewer;
        this._editor = editor;
        int levels = ViPreferenceService.getInstance().getInt("undolevels");
        if (this._viewer != null && this._viewer instanceof ITextViewerExtension6) {
            ITextViewerExtension6 _extension = (ITextViewerExtension6)this._viewer;
            this._undoManager = _extension.getUndoManager();
            this._undoManager.setMaximalUndoLevel(levels);
        } else {
            this._undoManager = new DefaultUndoManager(levels);
            viewer.setUndoManager(this._undoManager);
            this._undoManager.connect(this._viewer);
        }
    }

    public void redo() {
        this._editor.callAction("REDO");
        this._editor.setCaretPosition(this._editor.getSelection().getOffset());
    }

    public void undo() {
        this._editor.callAction("UNDO");
        this._editor.setCaretPosition(this._editor.getSelection().getOffset());
    }

    public void beginCompoundChange() {
        this._undoManager.beginCompoundChange();
    }

    public void endCompoundChange() {
        this._undoManager.endCompoundChange();
    }

    public boolean canUndo() {
        return this._undoManager.undoable();
    }

    public void setUndoLevels(int levels) {
        this._undoManager.setMaximalUndoLevel(levels);
    }
}

