/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse.undoextension;

import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viplugineclipse.EditorImplementation;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;

class ViDefaultUndoManager
implements com.mbartl.viimplementation.interfaces.IUndoManager {
    private IUndoManager _undoManager;
    private ITextViewer _viewer;
    private EditorImplementation _editor;

    public ViDefaultUndoManager(EditorImplementation editor, ITextViewer viewer) {
        this._viewer = viewer;
        this._editor = editor;
        int levels = ViPreferenceService.getInstance().getInt("undolevels");
        this._undoManager = new DefaultUndoManager(levels);
        viewer.setUndoManager(this._undoManager);
        this._undoManager.connect(this._viewer);
    }

    public void redo() {
        this._undoManager.redo();
        this._editor.setCaretPosition(this._editor.getSelection().getOffset());
    }

    public void undo() {
        this._undoManager.undo();
        this._editor.setCaretPosition(this._editor.getSelection().getOffset());
    }

    public void beginCompoundChange() {
        this._undoManager.beginCompoundChange();
    }

    public void endCompoundChange() {
        this._undoManager.endCompoundChange();
    }

    public boolean canUndo() {
        return this._undoManager.undoable();
    }

    public void setUndoLevels(int levels) {
        this._undoManager.setMaximalUndoLevel(levels);
    }
}

