/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viimplementation.interfaces.IEditor;
import com.mbartl.viimplementation.util.Region;
import com.mbartl.viplugineclipse.ViPluginPlugin;
import com.mbartl.viplugineclipse.actions.AddOneLevelOfIndentation;
import com.mbartl.viplugineclipse.actions.EraseBackOneWord;
import com.mbartl.viplugineclipse.actions.EraseOneLevelOfIndentation;
import com.mbartl.viplugineclipse.actions.SwitchToCommandMode;
import com.mbartl.viplugineclipse.foldingextension.FoldingExtensionFactory;
import com.mbartl.viplugineclipse.foldingextension.IFoldingExtension;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorImplementation
implements IEditor {
    private final ITextEditor _editor;
    private final ITextViewer _viewer;
    private final ITextViewerExtension2 _editorExtension2;
    private final IFoldingExtension _foldingExtension;
    private final StyledText _styledText;
    private Vector _lastSearchHighlightingRegions = new Vector();
    private Region _lastVisualSelection = null;
    private static final Color GRAY = Display.getDefault().getSystemColor(15);
    private static final Color YELLOW = Display.getDefault().getSystemColor(7);
    private static final Color BLACK = Display.getDefault().getSystemColor(2);

    public EditorImplementation(ITextEditor editor, ITextViewer viewer) {
        this._editor = editor;
        this._viewer = viewer;
        this._styledText = this._viewer.getTextWidget();
        this._editorExtension2 = this._viewer != null && this._viewer instanceof ITextViewerExtension2 ? (ITextViewerExtension2)this._viewer : null;
        this._foldingExtension = FoldingExtensionFactory.getFoldingExtension(this._editor, this._viewer);
        editor.setAction("com.mbartl.viplugineclipse.actions.SwitchToCommandMode", (IAction)new SwitchToCommandMode());
        editor.setAction("com.mbartl.viplugineclipse.actions.EraseBackOneWord", (IAction)new EraseBackOneWord());
        editor.setAction("com.mbartl.viplugineclipse.actions.EraseOneLevelOfIndentation", (IAction)new EraseOneLevelOfIndentation());
        editor.setAction("com.mbartl.viplugineclipse.actions.AddOneLevelOfIndentation", (IAction)new AddOneLevelOfIndentation());
    }

    public void setCaretPosition(int pos) {
        int currentPos = this.getCaretPosition();
        if (pos != currentPos) {
            int validPos = pos;
            boolean forward = currentPos < pos;
            validPos = this._foldingExtension.getValidCaretPosition(pos, forward);
            this._styledText.setCaretOffset(validPos);
            this._styledText.showSelection();
        }
    }

    public int getCaretPosition() {
        return this._foldingExtension.cursorOffset2DocumentOffset(this._styledText.getCaretOffset());
    }

    public void quit(boolean forceClose) {
        try {
            if (forceClose || !this._editor.isSaveOnCloseNeeded()) {
                this._editor.close(false);
            } else {
                MessageDialog.openInformation((Shell)this._editor.getSite().getWorkbenchWindow().getShell(), (String)"Can't close buffer", (String)"There are unsaved changes. To override use :q!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            IProgressMonitor pm = this._editor.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
            this._editor.doSave(pm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getTopIndex() {
        return this._viewer.getTopIndex();
    }

    public int getBottomIndex() {
        return this._viewer.getBottomIndex();
    }

    public void copySelectionToClipboard(Region region) {
        try {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            String contents = this._viewer.getDocument().get(region.getOffset(), region.getLength());
            try {
                clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError sWTError) {}
            clipboard.dispose();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setSelection(Region region) {
        if (this.resetVisualHighlighting()) {
            this.highlightSearchRegions(this._lastSearchHighlightingRegions);
        }
        this.highlightVisualSelection(region);
    }

    public Region getSelection() {
        ITextSelection sel = (ITextSelection)this._editor.getSelectionProvider().getSelection();
        return new Region(sel.getOffset(), sel.getLength());
    }

    public void revertToSaved() {
        this._editor.doRevertToSaved();
    }

    public void srollToLine(int line) {
        this._viewer.setTopIndex(line);
    }

    public void highlightSearchRegions(Vector regions) {
        this._lastSearchHighlightingRegions = regions;
        int i = 0;
        while (i < regions.size()) {
            Region region = (Region)regions.get(i);
            if ((region = this._foldingExtension.model2viewRegion(region)) != null) {
                StyleRange style = new StyleRange(region.getOffset(), region.getLength(), YELLOW, GRAY);
                this._styledText.setStyleRange(style);
            }
            ++i;
        }
    }

    private void highlightVisualSelection(Region selection) {
        this._lastVisualSelection = selection;
        Region viewSelection = this._foldingExtension.model2viewRegion(selection);
        if (viewSelection != null) {
            StyleRange style = new StyleRange(viewSelection.getOffset(), viewSelection.getLength(), BLACK, GRAY);
            this._styledText.setStyleRange(style);
        }
    }

    public void resetHighlighting(boolean invalidateSearchHighlighting) {
        if (this._lastSearchHighlightingRegions.size() != 0) {
            if (invalidateSearchHighlighting) {
                this._lastSearchHighlightingRegions = new Vector();
            }
            this._viewer.invalidateTextPresentation();
            this.highlightSearchRegions(this._lastSearchHighlightingRegions);
        }
    }

    private boolean resetVisualHighlighting() {
        if (this._lastVisualSelection != null && this._lastVisualSelection.getLength() != 0) {
            if (this._editorExtension2 != null) {
                this._editorExtension2.invalidateTextPresentation(this._lastVisualSelection.getOffset(), this._lastVisualSelection.getLength());
                return true;
            }
            this._viewer.invalidateTextPresentation();
            return true;
        }
        return false;
    }

    public boolean callAction(String actionId) {
        ViPluginPlugin.getDefault().log("callAction = " + actionId);
        IAction action = null;
        if ("NEW_LINE_BELOW".equals(actionId)) {
            action = this._editor.getAction("SmartEnter");
        } else if (actionId.equals("NEW_LINE_ABOVE")) {
            action = this._editor.getAction("SmartEnterInverse");
        } else if (!actionId.equals("OPEN_DECLARATION")) {
            if (actionId.equals("INDENT_LINE")) {
                action = this._editor.getAction("Indent");
            } else if ("UNDO".equals(actionId)) {
                action = this._editor.getAction(ActionFactory.UNDO.getId());
            } else if ("REDO".equals(actionId)) {
                action = this._editor.getAction(ActionFactory.REDO.getId());
            }
        }
        if (action != null) {
            action.run();
            return true;
        }
        return false;
    }

    public String getClipboardContent() {
        Clipboard clipboard = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String content = (String)clipboard.getContents((Transfer)textTransfer);
        clipboard.dispose();
        return content;
    }

    public void setLineNumbers(boolean on) {
        String preference = "lineNumberRuler";
        EditorsUI.getPreferenceStore().setValue(preference, on);
    }
}

