/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viimplementation.interfaces.AbstractDocumentAdapter;
import com.mbartl.viimplementation.layer.ViLayer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class DocumentAdapter
extends AbstractDocumentAdapter
implements IDocumentListener {
    private IDocument _document;
    private ViLayer _layer;
    private final boolean _isEditable;

    public DocumentAdapter(IDocument document, boolean isEditable) {
        this._document = document;
        this._document.addDocumentListener((IDocumentListener)this);
        this._isEditable = isEditable;
    }

    public String getText(int offset, int length) {
        try {
            return this._document.get(offset, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLength() {
        return this._document.getLength();
    }

    public void replaceText(int start, int length, String text) {
        try {
            if (this._isEditable) {
                this._document.replace(start, length, text);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this._layer.updateDocument();
    }

    public void setLayer(ViLayer layer) {
        this._layer = layer;
    }

    public void unregister() {
        this._document.removeDocumentListener((IDocumentListener)this);
    }
}

