/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viimplementation.interfaces.IBookmark;
import com.mbartl.viimplementation.util.BookMark;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BookMarkImplementation
implements IBookmark {
    private final ITextEditor _editor;

    public BookMarkImplementation(ITextEditor editor) {
        this._editor = editor;
    }

    public void add(BookMark bookMark) {
        try {
            IEditorInput editorInput = this._editor.getEditorInput();
            if (!(editorInput instanceof IFileEditorInput)) {
                return;
            }
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            IFile file = fileEditorInput.getFile();
            IMarker marker = this.getMarker(bookMark.getName());
            if (marker != null) {
                marker.delete();
            }
            HashMap map = new HashMap();
            MarkerUtilities.setMessage(map, (String)bookMark.getName());
            MarkerUtilities.setCharStart(map, (int)bookMark.getPos());
            MarkerUtilities.setCharEnd(map, (int)bookMark.getPos());
            MarkerUtilities.createMarker((IResource)file, map, (String)"org.eclipse.core.resources.bookmark");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void remove(String name) {
    }

    private IMarker getMarker(String name) {
        IEditorInput editorInput = this._editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
        IFile file = fileEditorInput.getFile();
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("message", "--").equals(name)) {
                    return markers[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

