/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viplugineclipse;

import com.mbartl.viimplementation.interfaces.AbstractDocumentAdapter;
import com.mbartl.viimplementation.interfaces.IBookmark;
import com.mbartl.viimplementation.interfaces.ICaret;
import com.mbartl.viimplementation.interfaces.IEditor;
import com.mbartl.viimplementation.interfaces.IKeyListener;
import com.mbartl.viimplementation.interfaces.IMessageDialog;
import com.mbartl.viimplementation.interfaces.IUndoManager;
import com.mbartl.viimplementation.interfaces.IViStatusLineManager;
import com.mbartl.viimplementation.layer.LayerInformation;
import com.mbartl.viimplementation.layer.ViLayer;
import com.mbartl.viimplementation.layer.ViLayerManager;
import com.mbartl.viplugineclipse.BookMarkImplementation;
import com.mbartl.viplugineclipse.DocumentAdapter;
import com.mbartl.viplugineclipse.EditorImplementation;
import com.mbartl.viplugineclipse.TheVerifyKeyListener;
import com.mbartl.viplugineclipse.ViCaret;
import com.mbartl.viplugineclipse.ViMessageDialog;
import com.mbartl.viplugineclipse.ViPluginPlugin;
import com.mbartl.viplugineclipse.ViStatusLineManager;
import com.mbartl.viplugineclipse.undoextension.SimpleUndoManager;
import com.mbartl.viplugineclipse.undoextension.ViUndoManagerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ActivateLayer {
    private static boolean _isIBMSSEEditor = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void activateLayer(IWorkbenchPart part) {
        ITextEditor editor = ActivateLayer.checkAndGetEditor(part);
        if (editor == null) {
            return;
        }
        if (ActivateLayer.layerExists(editor)) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            ViLayer layer = ViLayerManager.getInstance().getLayerById(editor.toString());
            if (document.get().equals(layer.getDocument().get())) {
                ViPluginPlugin.getDefault().log("activated layer: " + editor.toString());
                ViLayerManager.getInstance().activateLayer(editor.toString());
            } else {
                ViPluginPlugin.getDefault().log("reuse layer: " + editor.toString());
                ViLayerManager.getInstance().removeViLayer(editor.toString());
                ActivateLayer.createNewLayer(editor);
            }
        } else {
            ViPluginPlugin.getDefault().log("creating new layer: " + editor.toString());
            ActivateLayer.createNewLayer(editor);
        }
    }

    private static void createNewLayer(ITextEditor editor) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.AbstractTextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method me = clazz.getDeclaredMethod("getSourceViewer", null);
            me.setAccessible(true);
            Object viewer = me.invoke((Object)editor, null);
            ITextViewer textViewer = (ITextViewer)viewer;
            StyledText styledText = textViewer.getTextWidget();
            EditorImplementation editorImplementation = new EditorImplementation(editor, textViewer);
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            ViStatusLineManager slm = new ViStatusLineManager(editor.getEditorSite().getActionBars().getStatusLineManager());
            DocumentAdapter documentAdapter = new DocumentAdapter(document, editor.isEditable());
            LayerInformation info = new LayerInformation((IEditor)editorImplementation, (AbstractDocumentAdapter)documentAdapter);
            info.setStatusLineManager((IViStatusLineManager)slm);
            if (_isIBMSSEEditor) {
                info.setUndoManager((IUndoManager)new SimpleUndoManager(editorImplementation));
            } else {
                info.setUndoManager(ViUndoManagerFactory.getUndoManager(editorImplementation, textViewer));
            }
            info.setCaret((ICaret)new ViCaret(styledText));
            info.setBookmark((IBookmark)new BookMarkImplementation(editor));
            info.setMessageDialog((IMessageDialog)new ViMessageDialog(ViPluginPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()));
            ViLayer layer = ViLayerManager.getInstance().createLayer(editor.toString(), info);
            documentAdapter.setLayer(layer);
            layer.setKeyListener((IKeyListener)new TheVerifyKeyListener(layer, (ITextViewerExtension)viewer));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static ITextEditor checkAndGetEditor(IWorkbenchPart part) {
        _isIBMSSEEditor = false;
        if (part == null) {
            return null;
        }
        Object editor = null;
        if (part instanceof MultiPageEditorPart) {
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ui.part.MultiPageEditorPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method me = clazz.getDeclaredMethod("getActiveEditor", null);
                me.setAccessible(true);
                Object multiPageEditorPartActivePage = me.invoke((Object)part, null);
                if (multiPageEditorPartActivePage instanceof ITextEditor) {
                    editor = (ITextEditor)multiPageEditorPartActivePage;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (part instanceof ITextEditor) {
            editor = (ITextEditor)part;
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            editor = part.getAdapter((Class)clazz);
        }
        if (editor != null) {
            String editorClassName = editor.getClass().getName();
            ViPluginPlugin.getDefault().log("name = " + editorClassName);
            _isIBMSSEEditor = editorClassName.startsWith("com.ibm.sse.editor") || editorClassName.startsWith("com.genuitec") || editorClassName.startsWith("com.ibm.sed.editor") || editorClassName.startsWith("com.ibn.rct.editor");
        }
        return editor;
    }

    private static boolean layerExists(ITextEditor editor) {
        return ViLayerManager.getInstance().getLayerById(editor.toString()) != null;
    }
}

