/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.util;

import com.mbartl.viimplementation.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class WordSeparatorUtils {
    public static final String separatorDefaults = ".,(,), ,TAB,ENTER,:,;,?,+,=,ANGLE_BRACKET_RIGHT,ANGLE_BRACKET_LEFT,*,{,},\",|,COMMA,-,\\,/,@,[,],},~,!,#,$,%,^,AND,',`,\u00b4";
    private char[] _wordSeparators;
    private final char[] WORDSeparators = new char[]{' ', '\n', '\t'};

    public WordSeparatorUtils(String separators) {
        this.setWordSeparators(separators);
    }

    private void setWordSeparators(String separatorsString) {
        String[] separators = StringUtils.split((String)separatorsString, (String)",");
        this._wordSeparators = new char[separators.length];
        int i = 0;
        while (i < separators.length) {
            int ch = separators[i].equals("COMMA") ? 44 : (separators[i].equals("ENTER") ? 10 : (separators[i].equals("TAB") ? 9 : (separators[i].equals("ANGLE_BRACKET_LEFT") ? 60 : (separators[i].equals("ANGLE_BRACKET_RIGHT") ? 62 : (separators[i].equals("AND") ? 38 : (int)separators[i].charAt(0))))));
            this._wordSeparators[i] = ch;
            ++i;
        }
    }

    public boolean isWordEnding(char ch, boolean withSpace) {
        if (!(withSpace || ch != ' ' && ch != '\t' && ch != '\n')) {
            return false;
        }
        int i = 0;
        while (i < this._wordSeparators.length) {
            if (this._wordSeparators[i] == ch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getNextWord(String text, int startIndex) {
        char c;
        if (text == null || text.length() == 0) {
            return -1;
        }
        int endIndex = text.length();
        int newStartIndex = startIndex;
        if (this.isWordEnding(text.charAt(startIndex), false)) {
            int i = startIndex + 1;
            while (i < text.length()) {
                if (!this.isWordEnding(text.charAt(i), false)) break;
                newStartIndex = i++;
            }
        }
        int index = 0;
        int i = 0;
        while (i < this._wordSeparators.length) {
            index = text.indexOf(this._wordSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex) {
            i = newStartIndex + 1;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                    return i;
                }
                ++i;
            }
        }
        if (endIndex < text.length()) {
            if (text.charAt(endIndex) == ' ' || text.charAt(endIndex) == '\n') {
                i = endIndex;
                while (i < text.length()) {
                    c = text.charAt(i);
                    if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                        return i;
                    }
                    ++i;
                }
            }
        } else {
            --endIndex;
        }
        return endIndex;
    }

    public int getNextWORD(String text, int startIndex) {
        char c;
        if (text == null || text.length() == 0) {
            return -1;
        }
        int newStartIndex = startIndex;
        int endIndex = text.length();
        int index = 0;
        int i = 0;
        while (i < this.WORDSeparators.length) {
            index = text.indexOf(this.WORDSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex) {
            i = newStartIndex + 1;
            while (i < text.length()) {
                c = text.charAt(i);
                if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                    return i;
                }
                ++i;
            }
        }
        if (endIndex < text.length()) {
            if (text.charAt(endIndex) == ' ' || text.charAt(endIndex) == '\n') {
                i = endIndex;
                while (i < text.length()) {
                    c = text.charAt(i);
                    if (this.isWordEnding(c, false) || WordSeparatorUtils.isWordCharacter(c)) {
                        return i;
                    }
                    ++i;
                }
            }
        } else {
            --endIndex;
        }
        return endIndex;
    }

    public int getPreviousWord(String text, int startIndex) {
        int i = startIndex;
        while (i >= 0) {
            int wordPos = this.getNextWord(text, i);
            if (wordPos < startIndex) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getPreviousWORD(String text, int startIndex) {
        int i = startIndex;
        while (i >= 0) {
            int wordPos = this.getNextWORD(text, i);
            if (wordPos < startIndex) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int getEndOfCurrentWord(String text, int startIndex, boolean selectUntilLastEndCharacter) {
        int newStartIndex = TextUtils.getFirstVisibleCharacter(text, startIndex + 1);
        if (newStartIndex == -1) {
            return startIndex;
        }
        int endIndex = text.length();
        int index = 0;
        int i = 0;
        while (i < this._wordSeparators.length) {
            index = text.indexOf(this._wordSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        if (newStartIndex == endIndex && selectUntilLastEndCharacter) {
            i = startIndex + 2;
            while (i < text.length()) {
                if (!this.isWordEnding(text.charAt(i), false)) break;
                endIndex = i++;
            }
            return endIndex;
        }
        return endIndex - 1;
    }

    public int getEndOfCurrentWORD(String text, int startIndex) {
        int newStartIndex = TextUtils.getFirstVisibleCharacter(text, startIndex + 1);
        if (newStartIndex == -1) {
            return startIndex;
        }
        int endIndex = text.length();
        int index = 0;
        int i = 0;
        while (i < this.WORDSeparators.length) {
            index = text.indexOf(this.WORDSeparators[i], newStartIndex);
            if (index >= 0 && index < endIndex) {
                endIndex = index;
            }
            ++i;
        }
        return endIndex - 1;
    }

    public static boolean isWordCharacter(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }
}

