/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.search;

import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.search.SimpleSearch;
import com.mbartl.viimplementation.util.Region;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExSearch
extends Search {
    public Region search(String text, String regex, int direction, int mode, int startPos) {
        Matcher matcher;
        if (regex == null || regex.length() == 0) {
            return null;
        }
        try {
            Pattern pat = Pattern.compile(regex, this.getFlags());
            matcher = pat.matcher(text);
        }
        catch (PatternSyntaxException e) {
            SimpleSearch search = new SimpleSearch();
            return search.search(text, regex, direction, mode, startPos);
        }
        int pos = startPos;
        if (direction == 0) {
            if (mode == 0 || mode == 1) {
                if (++pos > text.length() - 1) {
                    pos = 0;
                }
                return this.searchForward(matcher, text, pos);
            }
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            return this.searchBackward(matcher, text, pos);
        }
        if (mode == 0 || mode == 1) {
            if (--pos < 0) {
                pos = text.length() - 1;
            }
            return this.searchBackward(matcher, text, pos);
        }
        if (++pos > text.length() - 1) {
            pos = 0;
        }
        return this.searchForward(matcher, text, pos);
    }

    private Region searchForward(Matcher matcher, String text, int startPos) {
        int idx = -1;
        String foundStr = "";
        if (matcher.find(startPos) || matcher.find()) {
            idx = matcher.start();
            foundStr = matcher.group();
        }
        if (idx != -1) {
            return new Region(idx, foundStr.length());
        }
        return null;
    }

    private Region searchBackward(Matcher matcher, String text, int startPos) {
        int idx = -1;
        String foundStr = "";
        int newCursor = -1;
        while (matcher.find(++newCursor)) {
            newCursor = matcher.start();
            if (newCursor > startPos) break;
            idx = newCursor;
            foundStr = matcher.group();
        }
        if (idx == -1) {
            newCursor = -1;
            while (matcher.find(++newCursor)) {
                idx = newCursor = matcher.start();
                foundStr = matcher.group();
            }
        }
        if (idx != -1) {
            return new Region(idx, foundStr.length());
        }
        return null;
    }

    private int getFlags() {
        boolean ignoreCase = ViPreferenceService.getInstance().getBoolean("ignorecase");
        int flags = 8;
        if (ignoreCase) {
            flags |= 2;
        }
        return flags;
    }
}

