/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.parser;

import com.mbartl.viimplementation.parser.CommandProperties;
import com.mbartl.viimplementation.parser.ParsedCommand;
import java.util.LinkedList;
import java.util.List;

public class Parser {
    private static final String ENTER = String.valueOf('\n');
    private static final String[] specialCommands = new String[]{"r", "d'", "d`", "dt", "dT", "df", "dF", "d/", "y'", "y`", "yt", "yT", "yf", "yF", "y/", "c'", "c`", "ct", "cT", "cf", "cF", "c/", ">'", ">`", "<'", "<`", "t", "f", "T", "F", "m", "'", "`", "q", "@"};
    private static final String[] commands = new String[]{"d", "D", "dd", "c", "S", "cc", "C", "y", "Y", "yy", "i", "I", "a", "A", "o", "O", "s", "v", "V", "<CD>", "<CU>", "<CL>", "<CR>", "<SD>", "<SU>", "h", "j", "k", "l", "H", "L", "M", "0", "^", "$", "w", "b", "e", "W", "B", "E", "gg", "G", "*", "#", "{", "}", "J", "+", "-", "_", "<", ">", "<<", ">>", "~", "gd", "gu", "gU", "g~", "guu", "gUU", "x", "X", "p", "P", "n", "N", ";", ",", ".", "u", "U", "R", "ZZ", "ZQ", "zz", "zt", "zb", "z.", "z-", "z+", "z" + ENTER, "%", " ", "==", ENTER};
    private static final String[] modifiers = new String[]{"0", "^", "$", "w", "b", "e", "d", "E", "W", "B", "h", "j", "k", "l", "G", "gg", ";", ",", "<CL>", "<CR>", "<CU>", "<CD>", "%", "{", "}", " "};

    private static boolean checkValidity(String command) {
        int cmdLength = command.length();
        if (cmdLength == 0) {
            return true;
        }
        int i = 0;
        while (i < specialCommands.length) {
            String verifyCommand = specialCommands[i];
            if (verifyCommand.length() <= cmdLength && verifyCommand.startsWith(command.substring(0, verifyCommand.length()))) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < commands.length) {
            int j = 0;
            while (j < modifiers.length) {
                String verifyCommand = String.valueOf(commands[i]) + modifiers[j];
                if (verifyCommand.length() >= cmdLength && command.startsWith(verifyCommand.substring(0, cmdLength))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static List splitString(String str) {
        LinkedList<String> strList = new LinkedList<String>();
        boolean mode = Character.isDigit(str.charAt(0));
        StringBuffer part = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (mode && Character.isDigit(str.charAt(i))) {
                part.append(str.charAt(i));
            } else if (!mode && !Character.isDigit(str.charAt(i))) {
                part.append(str.charAt(i));
            } else {
                strList.add(part.toString());
                part = new StringBuffer();
                part.append(str.charAt(i));
                mode = !mode;
            }
            ++i;
        }
        strList.add(part.toString());
        return strList;
    }

    private static String extractCounter(String command, ParsedCommand pc) {
        if (command.length() == 0) {
            return "";
        }
        String result = "";
        int counter = 1;
        boolean useCounter = false;
        List list = Parser.splitString(command);
        int i = 0;
        while (i < list.size()) {
            String part = (String)list.get(i);
            if (!Character.isDigit(part.charAt(0))) {
                result = String.valueOf(result) + part;
            } else if (list.size() - 1 == i) {
                int j = 0;
                while (j < specialCommands.length) {
                    String verifyCommand = specialCommands[j];
                    if (verifyCommand.length() <= result.length() && verifyCommand.startsWith(result.substring(0, verifyCommand.length()))) {
                        result = String.valueOf(result) + part;
                    }
                    ++j;
                }
            } else {
                counter *= Integer.parseInt(part);
                useCounter = true;
            }
            ++i;
        }
        pc.setCounter(counter);
        pc.setExplicitCounter(useCounter);
        return result;
    }

    private static String extractRegister(String command, ParsedCommand pc) {
        if (command.startsWith("\"")) {
            if (command.length() == 1) {
                return "";
            }
            pc.setRegister("<" + command.charAt(1) + ">");
            return command.substring(2, command.length());
        }
        return command;
    }

    private static String extractRange(String command, ParsedCommand pc) {
        String cmd = command;
        if (cmd.charAt(0) == '%') {
            pc.setRange("%");
            return cmd.substring(1);
        }
        int idx = cmd.indexOf(",");
        if (idx != -1) {
            String start = cmd.substring(0, idx);
            String end = cmd.substring(idx + 1).trim();
            int i = 0;
            while (i < end.length()) {
                char c = end.charAt(i);
                if (c == '\'') {
                    pc.setRange(String.valueOf(start) + "," + end.substring(0, i + 2));
                    return end.substring(i + 2).trim();
                }
                if (!Character.isDigit(c) && c != '$' && c != '+' && c != '-' && c != '.') {
                    pc.setRange(String.valueOf(start) + "," + end.substring(0, i));
                    return end.substring(i).trim();
                }
                ++i;
            }
        }
        return command;
    }

    public static ParsedCommand parse(String command) {
        ParsedCommand pc = new ParsedCommand();
        if (command.equals("0") || command.startsWith("/") || command.startsWith("?")) {
            pc.setOperation(command);
        } else if (command.startsWith(":")) {
            if (command.endsWith(ENTER)) {
                command = ":" + Parser.extractRange(command.substring(1, command.length() - 1).trim(), pc).trim() + ENTER;
                pc.setOperation(command);
            } else {
                pc.setOperation(command);
            }
        } else if (command.equals("d0")) {
            pc.setOperation("d");
            pc.setModifier("0");
        } else {
            String operation = Parser.extractCounter(command = Parser.extractRegister(command, pc), pc);
            if (!Parser.checkValidity(operation)) {
                return null;
            }
            pc.setOperation(operation);
        }
        CommandProperties.setCommandProperties(pc);
        return pc;
    }
}

