/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.select;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.select.SelectCharacters;
import com.mbartl.viimplementation.command.actions.select.SelectCharactersBackwards;
import com.mbartl.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viimplementation.command.actions.select.SelectToBookmark;
import com.mbartl.viimplementation.command.actions.select.SelectToCharacter;
import com.mbartl.viimplementation.command.actions.select.SelectToCharacterBackward;
import com.mbartl.viimplementation.command.actions.select.SelectToLineBegin;
import com.mbartl.viimplementation.command.actions.select.SelectToLineBeginNonBlank;
import com.mbartl.viimplementation.command.actions.select.SelectToLineEnd;
import com.mbartl.viimplementation.command.actions.select.SelectToMatchBrace;
import com.mbartl.viimplementation.command.actions.select.SelectToNextBlankLine;
import com.mbartl.viimplementation.command.actions.select.SelectToPreviousBlankLine;
import com.mbartl.viimplementation.command.actions.select.SelectToWordEnd;
import com.mbartl.viimplementation.command.actions.select.SelectWord;

public class SelectionCommandFactory {
    public static Command createCommand(String modifier, int counter) {
        String m = modifier;
        int c = counter;
        Command command = null;
        if (m.equals("<CD>") || m.equals("j")) {
            command = new SelectLines(c + 1, 1, true);
        } else if (m.equals("<CU>") || m.equals("k")) {
            command = new SelectLines(c, 0, true);
        } else if (m.equals("w")) {
            command = new SelectWord(c, true, false);
        } else if (m.equals("W")) {
            command = new SelectWord(c, true, true);
        } else if (m.equals("b")) {
            command = new SelectWord(c, false, false);
        } else if (m.equals("B")) {
            command = new SelectWord(c, false, true);
        } else if (m.equals("e")) {
            command = new SelectToWordEnd(c, false, false);
        } else if (m.equals("E")) {
            command = new SelectToWordEnd(c, true, false);
        } else if (m.equals("$")) {
            command = new SelectToLineEnd(c);
        } else if (m.equals("0")) {
            command = new SelectToLineBegin();
        } else if (m.equals("^")) {
            command = new SelectToLineBeginNonBlank();
        } else if (m.equals("<CL>") || m.equals("l") || m.equals(" ")) {
            command = new SelectCharacters(c);
        } else if (m.equals("<CR>") || m.equals("h")) {
            command = new SelectCharactersBackwards(c);
        } else if (m.startsWith("'") && m.length() > 1) {
            command = new SelectToBookmark(m.charAt(1), 0, true);
        } else if (m.startsWith("`") && m.length() > 1) {
            command = new SelectToBookmark(m.charAt(1), 1, true);
        } else if (m.startsWith("t") && m.length() > 1) {
            command = new SelectToCharacter(c, m.charAt(1), false);
        } else if (m.startsWith("f") && m.length() > 1) {
            command = new SelectToCharacter(c, m.charAt(1), true);
        } else if (m.startsWith("T") && m.length() > 1) {
            command = new SelectToCharacterBackward(c, m.charAt(1), false);
        } else if (m.startsWith("F") && m.length() > 1) {
            command = new SelectToCharacterBackward(c, m.charAt(1), true);
        } else if (m.equals("}")) {
            command = new SelectToNextBlankLine(c);
        } else if (m.equals("{")) {
            command = new SelectToPreviousBlankLine(c);
        } else if (m.equals("%")) {
            command = new SelectToMatchBrace();
        } else if (m.equals("G")) {
            command = new SelectLines(1, true);
        } else if (m.equals("gg")) {
            command = new SelectLines(0, true);
        }
        return command;
    }
}

