/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.select;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.util.Line;

public class SelectToWordEnd
extends Command {
    private int _counter;
    private boolean _fullWord;
    private boolean _selectUntilLastEndCharacter;

    public SelectToWordEnd(int counter, boolean fullWord, boolean selectUntilLastEndCharacter) {
        this._counter = counter;
        this._fullWord = fullWord;
        this._selectUntilLastEndCharacter = selectUntilLastEndCharacter;
    }

    public void execute() {
        int start;
        int end = start = this._editor.getCaretPosition();
        String text = this._document.get();
        end = this._fullWord ? this.getEndOfCurrentWORD(this._counter, end, text) : this.getEndOfCurrentWord(this._counter, end, text);
        ++end;
        if (this._counter == 1) {
            Line line = this._analyzer.getLineOfOffset(start);
            end = Math.min(end, line.getOffsetEndWithoutDelimiter());
        }
        int length = end - start;
        this._selectionManager.setInternalSelection(start, length);
    }

    private int getEndOfCurrentWord(int counter, int startPos, String text) {
        int newPos = startPos - 1;
        int i = 0;
        while (i < counter) {
            ++newPos;
            newPos = this._viLayer.getWordSeparatorUtils().getEndOfCurrentWord(text, newPos, this._selectUntilLastEndCharacter);
            ++i;
        }
        return newPos;
    }

    private int getEndOfCurrentWORD(int counter, int startPos, String text) {
        int newPos = startPos;
        int i = 0;
        while (i < counter) {
            newPos = this._viLayer.getWordSeparatorUtils().getEndOfCurrentWORD(text, newPos);
            ++i;
        }
        return newPos;
    }
}

