/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.motion;

import com.mbartl.viimplementation.command.actions.HighlightWord;
import com.mbartl.viimplementation.command.actions.motion.MotionCommand;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.search.SearchFactory;
import com.mbartl.viimplementation.util.Region;
import com.mbartl.viimplementation.util.WordSeparatorUtils;

public class MoveCurrentWord
extends MotionCommand {
    private final boolean _forward;

    public MoveCurrentWord(int counter, boolean forward) {
        super(counter);
        this._forward = forward;
    }

    public void execute() {
        Search search = SearchFactory.getRegExpSearch();
        String text = this._document.get();
        String word = this.getWord(text, this._editor.getCaretPosition());
        search.setLastSearch("\\b" + word + "\\b");
        Region result = this._forward ? search.search(text, "\\b" + word + "\\b", 0, 1, this._editor.getCaretPosition()) : search.search(text, "\\b" + word + "\\b", 1, 1, this._editor.getCaretPosition());
        if (result != null) {
            new HighlightWord("\\b" + word + "\\b", true).execute();
            this._editor.setCaretPosition(result.getOffset());
        }
    }

    private String getWord(String text, int cursorPos) {
        int pos = this.skipToken(text, cursorPos);
        int start = this.getWordStart(text, pos);
        int end = this.getWordEnd(text, pos);
        return text.substring(start, end);
    }

    private int getWordStart(String text, int cursorPos) {
        int i = cursorPos - 1;
        while (i >= 0) {
            if (!WordSeparatorUtils.isWordCharacter(text.charAt(i))) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private int getWordEnd(String text, int cursorPos) {
        int i = cursorPos + 1;
        while (i < text.length()) {
            if (!WordSeparatorUtils.isWordCharacter(text.charAt(i))) {
                return i;
            }
            ++i;
        }
        return text.length() - 1;
    }

    private int skipToken(String text, int cursorPos) {
        int pos = cursorPos;
        int i = cursorPos;
        while (i < text.length()) {
            if (WordSeparatorUtils.isWordCharacter(text.charAt(i))) {
                pos = i;
                break;
            }
            ++i;
        }
        return pos;
    }
}

