/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.change;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.motion.GotoLine;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.util.Line;
import com.mbartl.viimplementation.util.Region;
import com.mbartl.viimplementation.util.TextUtils;

public class ShiftSelection
extends Command {
    private Region _selection;
    private int _startLinePos;
    private int _endLinePos;
    private int _counter;
    private boolean _left;

    public ShiftSelection(int counter, boolean left) {
        this._left = left;
        this._counter = counter;
        this._selection = this._selectionManager.getSelection();
        if (this._selection.getLength() == 0) {
            this._startLinePos = this._analyzer.getLinePosOfOffset(this._editor.getCaretPosition());
            this._endLinePos = Math.min(this._analyzer.getNumberOfLines() - 1, this._startLinePos + this._counter - 1);
            this._counter = 1;
        } else {
            this._startLinePos = this._analyzer.getLinePosOfOffset(this._selection.getOffset());
            this._endLinePos = this._analyzer.getLinePosOfOffset(this._selection.getOffsetEnd());
            if (this._viLayer.isInVisualLineMode()) {
                --this._endLinePos;
            }
        }
    }

    public void execute() {
        this._viLayer.getUndoManager().beginCompoundChange();
        int shiftWidth = ViPreferenceService.getInstance().getInt("shiftwidth");
        boolean expandTab = ViPreferenceService.getInstance().getBoolean("expandtab");
        int i = this._startLinePos;
        while (i <= this._endLinePos) {
            Line line = this._analyzer.getLine(i);
            String lineText = this._document.getText(line.getOffset(), line.getLength());
            String shiftedText = TextUtils.shiftText(lineText, this._counter, this._left, shiftWidth, expandTab);
            this._document.replace(line.getOffset(), line.getLength(), shiftedText);
            this._viLayer.updateDocument();
            ++i;
        }
        new GotoLine(this._startLinePos, 2, false).execute();
        this._selectionManager.resetSelection();
        this._viLayer.getUndoManager().endCompoundChange();
    }
}

