/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions.change;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.util.Line;
import com.mbartl.viimplementation.util.TextUtils;

public class NewLineAbove
extends Command {
    private final boolean _useEclipseAction;

    public NewLineAbove(boolean useEclipseAction) {
        this._useEclipseAction = useEclipseAction;
    }

    public void execute() {
        Line line;
        boolean successfull;
        if (this._useEclipseAction && (successfull = (line = this._analyzer.getLineOfOffset(this._editor.getCaretPosition())) != null && line.getLengthWithoutDelimiter() == 0 ? this._editor.callAction("NEW_LINE_BELOW") : this._editor.callAction("NEW_LINE_ABOVE"))) {
            return;
        }
        if (this._analyzer.isEmptyDocument()) {
            this._document.replace(0, 0, "\n");
            this._editor.setCaretPosition(0);
            return;
        }
        Line line2 = this._analyzer.getLineOfOffset(this._editor.getCaretPosition());
        String delim = line2.getDelimiter();
        String whiteSpace = "";
        int smartPos = TextUtils.getFirstVisibleCharacter(this._document.getText(line2.getOffset(), line2.getLength()), 0);
        if (smartPos != -1) {
            whiteSpace = this._document.getText(line2.getOffset(), smartPos);
        }
        int pos = line2.getOffset();
        this._document.replace(pos, 0, String.valueOf(whiteSpace) + delim);
        this._viLayer.updateDocument();
        Line newLine = this._analyzer.getLineOfOffset(pos);
        this._editor.setCaretPosition(newLine.getOffsetEndWithoutDelimiter());
    }
}

