/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.registers.TextBuffer;
import com.mbartl.viimplementation.registers.YankBufferHandler;
import com.mbartl.viimplementation.util.Region;

public class YankSelection
extends Command {
    private final String _register;
    private final boolean _append;

    public YankSelection(String register) {
        if (Character.isUpperCase(register.charAt(1))) {
            this._append = true;
            this._register = register.toLowerCase();
        } else {
            this._append = false;
            this._register = register;
        }
    }

    public void execute() {
        Region selection = this._selectionManager.getSelection();
        String text = this._document.getText(selection.getOffset(), selection.getLength());
        TextBuffer textBuffer = YankBufferHandler.getInstance().getBuffer(this._register);
        if (this._append) {
            textBuffer.append(text);
        } else {
            textBuffer.fill(text, this._document.get());
        }
        boolean copytoclipboard = ViPreferenceService.getInstance().getBoolean("copytoclipboard");
        if (this._register.equals("<*>") || copytoclipboard && this._register.equals("<default>")) {
            this._editor.copySelectionToClipboard(selection);
        }
    }
}

