/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.HighlightWord;
import com.mbartl.viimplementation.interfaces.IEditor;
import com.mbartl.viimplementation.layer.ViLayerManager;
import com.mbartl.viimplementation.preferences.ViPreferenceService;
import com.mbartl.viimplementation.search.Search;
import com.mbartl.viimplementation.util.Region;
import java.util.Vector;

public class SearchDelegate {
    private final int _startPos;
    private final IEditor _editor;
    private final Search _search;
    private Command _postCommand = null;
    private int _searchState;
    private final int _direction;
    private final boolean _hlsearch;
    private final boolean _incsearch;
    private String _saveForRepetition;
    public static final int INPROGRESS = 0;
    public static final int INTERRUPTED = 1;
    public static final int FINISHED = 2;

    public SearchDelegate(Search search, int direction) {
        this._search = search;
        this._searchState = 0;
        this._direction = direction;
        this._saveForRepetition = "";
        this._hlsearch = ViPreferenceService.getInstance().getBoolean("hlsearch");
        this._incsearch = ViPreferenceService.getInstance().getBoolean("incsearch");
        this._editor = ViLayerManager.getInstance().getCurrentLayer().getEditor();
        this._editor.resetHighlighting(true);
        this._startPos = this._editor.getCaretPosition();
    }

    public SearchDelegate(Search search, int direction, Command postCommand, String saveForRepetition) {
        this(search, direction);
        this._postCommand = postCommand;
        this._saveForRepetition = saveForRepetition;
    }

    public void search(String searchCommand) {
        String text = ViLayerManager.getInstance().getCurrentLayer().getDocument().get();
        if (searchCommand.length() >= 1) {
            char lastChar = searchCommand.charAt(searchCommand.length() - 1);
            if (lastChar == '\u001b') {
                this._searchState = 1;
                this._saveForRepetition = "";
            } else if (lastChar == '\n') {
                String word = searchCommand.substring(1, searchCommand.length() - 1);
                this._searchState = 2;
                this._saveForRepetition = String.valueOf(this._saveForRepetition) + searchCommand;
                Region result = this._search.search(text, word, this._direction, this._startPos);
                if (result != null) {
                    this.setCursor(result.getOffset(), true);
                    if (this._postCommand != null) {
                        this.executePostCommand();
                    } else {
                        this.highlightSearchResults(word, true);
                    }
                } else {
                    this.setCursor(this._startPos, true);
                    this._editor.resetHighlighting(true);
                }
            } else {
                Region result = this._search.search(text, searchCommand.substring(1), this._direction, this._startPos);
                if (result != null) {
                    this.setCursor(result.getOffset(), false);
                    this.highlightSearchResults(searchCommand.substring(1), false);
                } else {
                    this.setCursor(this._startPos, true);
                    this._editor.resetHighlighting(true);
                }
            }
        }
    }

    public int getSearchState() {
        return this._searchState;
    }

    public String getSaveForRepetition() {
        if (this._postCommand != null) {
            return this._saveForRepetition;
        }
        return null;
    }

    private void executePostCommand() {
        this._postCommand.execute();
    }

    private void highlightSearchResults(String word, boolean all) {
        if (this._hlsearch) {
            if (all) {
                new HighlightWord(word, all).execute();
            } else if (this._incsearch) {
                Vector<Region> ranges = new Vector<Region>();
                ranges.add(new Region(this._editor.getCaretPosition(), word.length()));
                this._editor.resetHighlighting(true);
                this._editor.highlightSearchRegions(ranges);
            }
        }
    }

    private void setCursor(int pos, boolean force) {
        if (this._incsearch || force) {
            this._editor.setCaretPosition(pos);
        }
    }
}

