/*
 * Decompiled with CFR 0.152.
 */
package com.mbartl.viimplementation.command.actions;

import com.mbartl.viimplementation.command.actions.Command;
import com.mbartl.viimplementation.command.actions.select.SelectLines;
import com.mbartl.viimplementation.search.GetOccurences;
import com.mbartl.viimplementation.util.Region;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ReplaceExpressionInSelection
extends Command {
    private String _match = null;
    private String _replace;
    private boolean _global;
    private boolean _finished = false;
    private boolean _confirm = false;
    private Vector _matchBuffers;
    private Vector _replaceBuffers;
    private Vector _occurences;
    private String _command;
    private int _adjustment = 0;
    private int _index = 0;

    public ReplaceExpressionInSelection(String command) {
        this._command = command;
        this._command = this.setSelection(this._command);
        this._command = this.parseMatchAndReplaceString(this._command);
        if (this._command == null) {
            return;
        }
        this.parseFlags(this._command);
        this._matchBuffers = this.extractMatchBuffers(this._match);
        this._replaceBuffers = this.extractReplaceBuffers(this._replace);
    }

    public void execute() {
        if (this._command == null) {
            return;
        }
        this._viLayer.getUndoManager().beginCompoundChange();
        this._occurences = GetOccurences.getInSelection(this._document.get(), this._match, this._selectionManager.getSelection(), this._global);
        if (this._occurences.size() == 0) {
            this._finished = true;
            return;
        }
        if (!this._confirm) {
            this.replaceOccurences(this._occurences);
            this._viLayer.getUndoManager().endCompoundChange();
        } else {
            Region selection = (Region)this._occurences.get(0);
            this._editor.setCaretPosition(selection.getOffset());
            this._viLayer.setStatusLine("Replace Occurence: y/n/a/q");
        }
    }

    private String setSelection(String command) {
        if (this._selectionManager.getSelection().getLength() == 0) {
            new SelectLines(1, 1, false).execute();
        }
        return command.substring(2);
    }

    private void parseFlags(String command) {
        if (command.startsWith("/")) {
            if (StringUtils.contains((String)command, (char)'g')) {
                this._global = true;
            }
            StringUtils.contains((String)command, (char)'i');
            if (StringUtils.contains((String)command, (char)'c')) {
                this._confirm = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseMatchAndReplaceString(String command) {
        boolean nextIsEscaped = false;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < command.length()) {
            if (command.charAt(i) == '\\') {
                nextIsEscaped = !nextIsEscaped;
                buffer.append(command.charAt(i));
            } else if (command.charAt(i) == '/') {
                if (!nextIsEscaped) {
                    if (this._match != null) {
                        this._replace = buffer.toString();
                        this._replace = StringUtils.replace((String)this._replace, (String)"\\/", (String)"/");
                        this._replace = StringUtils.replace((String)this._replace, (String)"\\\\", (String)"\\");
                        return command.substring(i);
                    }
                    this._match = buffer.toString();
                    buffer = new StringBuffer("");
                } else {
                    buffer.append(command.charAt(i));
                }
                nextIsEscaped = false;
            } else {
                nextIsEscaped = false;
                buffer.append(command.charAt(i));
            }
            ++i;
        }
        return null;
    }

    private Vector extractMatchBuffers(String match) {
        int idx2;
        Vector<String> buffers = new Vector<String>();
        int idx = 0;
        while ((idx = match.indexOf("\\(", idx)) != -1 && (idx2 = match.indexOf("\\)", idx)) != -1) {
            buffers.add(match.substring(idx + 2, idx2));
            match = String.valueOf(match.substring(0, idx)) + match.substring(idx + 2, idx2) + match.substring(idx2 + 2);
        }
        this._match = match;
        return buffers;
    }

    private Vector extractReplaceBuffers(String replace) {
        Vector<String> buffers;
        block6: {
            buffers = new Vector<String>();
            if (replace.equals("")) {
                return buffers;
            }
            int idx = 0;
            while ((idx = replace.indexOf("\\", idx)) != -1 && replace.length() > idx + 1) {
                try {
                    String nr = replace.substring(idx + 1, idx + 2);
                    Integer.parseInt(nr);
                }
                catch (NumberFormatException e) {
                    ++idx;
                    continue;
                }
                String entry = replace.substring(0, idx);
                if (entry.length() > 0) {
                    buffers.add(entry);
                }
                if ((entry = replace.substring(idx, idx + 2)).length() > 0) {
                    buffers.add(entry);
                }
                replace = replace.substring(idx + 2);
            }
            if (replace.length() <= 0) break block6;
            buffers.add(replace);
        }
        return buffers;
    }

    private void replaceOccurences(Vector occurences) {
        int i = 0;
        while (i < occurences.size()) {
            this.replaceOccurence(occurences, i);
            ++i;
        }
    }

    private void replaceOccurence(Vector occurences, int index) {
        Region selection = (Region)occurences.get(index);
        String replace = this.getCurrentReplaceString(selection);
        this._viLayer.setStatusLine("Replace occurence: y/n/a/q");
        this._document.replace(selection.getOffset() + this._adjustment, selection.getLength(), replace);
        this._adjustment += replace.length() - selection.getLength();
    }

    private String getCurrentReplaceString(Region selection) {
        String replaceString = "";
        int i = 0;
        while (i < this._replaceBuffers.size()) {
            String buffer = (String)this._replaceBuffers.get(i);
            if (buffer.charAt(0) == '\\' && buffer.length() > 1 && Character.isDigit(buffer.charAt(1))) {
                int nr = Integer.parseInt(buffer.substring(1));
                String match = (String)this._matchBuffers.get(nr - 1);
                Vector occurence = GetOccurences.getInSelection(this._document.get(), match, selection, this._global);
                Region matchingRegion = (Region)occurence.get(0);
                replaceString = String.valueOf(replaceString) + this._document.getText(matchingRegion.getOffset(), matchingRegion.getLength());
            } else {
                replaceString = String.valueOf(replaceString) + buffer;
            }
            ++i;
        }
        return replaceString;
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void next(String command) {
        if (command.equalsIgnoreCase("y")) {
            this.replaceOccurence(this._occurences, this._index);
        } else {
            if (command.equalsIgnoreCase("a")) {
                while (this._index < this._occurences.size()) {
                    this.replaceOccurence(this._occurences, this._index);
                    ++this._index;
                }
                this._finished = true;
                return;
            }
            if (command.equalsIgnoreCase("q")) {
                this._finished = true;
                return;
            }
        }
        ++this._index;
        if (this._index == this._occurences.size()) {
            this._finished = true;
        } else {
            Region selection = (Region)this._occurences.get(this._index);
            int start = selection.getOffset() + this._adjustment;
            this._editor.setCaretPosition(start);
            Vector<Region> regions = new Vector<Region>();
            regions.add(new Region(start, selection.getLength()));
        }
    }
}

