/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.Zipper;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class TomcatProjectZipper
extends Zipper {
    private boolean acceptSource = false;

    public TomcatProjectZipper(File outputFile, File directory, boolean acceptSource) throws IOException {
        super(outputFile, directory);
        this.acceptSource = acceptSource;
    }

    protected boolean acceptDir(File dir) {
        if (dir.getName().equals("jsp") && dir.getParentFile().getName().equals("apache") && dir.getParentFile().getParentFile().getName().equals("org")) {
            return false;
        }
        String excludeString = TomcatPluginResources.PROJECT_WAREXPORT_EXCLUDE_DIRECTORIES;
        StringTokenizer tokenizer = new StringTokenizer(excludeString, ";");
        while (tokenizer.hasMoreTokens()) {
            String eachDir = tokenizer.nextToken();
            if (!dir.getName().equals(eachDir)) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptFile(File file) {
        if (file.getName().endsWith(".java")) {
            return this.acceptSource;
        }
        String excludeString = TomcatPluginResources.PROJECT_WAREXPORT_EXCLUDE_FILES;
        StringTokenizer tokenizer = new StringTokenizer(excludeString, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!file.getName().equals(tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }
}

