/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.FileUtil;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TomcatManagerAppPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
TomcatPluginResources {
    private String DEFAULT_MANAGER_URL = "http://localhost:8080/manager";
    private StringFieldEditor urlEditor;
    private StringFieldEditor userEditor;
    private StringFieldEditor pwdEditor;

    public TomcatManagerAppPreferencePage() {
        super(1);
        this.setPreferenceStore(TomcatLauncherPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Group box = new Group(this.getFieldEditorParent(), 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        box.setLayoutData((Object)gd);
        box.setLayout((Layout)new GridLayout(1, true));
        Label details = new Label((Composite)box, 64);
        details.setText(TomcatPluginResources.PREF_PAGE_MANAGER_BANNER);
        new Label(this.getFieldEditorParent(), 0);
        new Label(this.getFieldEditorParent(), 0);
        this.urlEditor = new StringFieldEditor("managerUrl", TomcatPluginResources.PREF_PAGE_MANAGER_URL, this.getFieldEditorParent());
        this.addField((FieldEditor)this.urlEditor);
        new Label(this.getFieldEditorParent(), 0);
        new Label(this.getFieldEditorParent(), 0);
        this.userEditor = new StringFieldEditor("managerUser", TomcatPluginResources.PREF_PAGE_MANAGER_USER, this.getFieldEditorParent());
        this.addField((FieldEditor)this.userEditor);
        this.pwdEditor = new StringFieldEditor("managerPassword", TomcatPluginResources.PREF_PAGE_MANAGER_PASSWORD, this.getFieldEditorParent());
        this.addField((FieldEditor)this.pwdEditor);
        new Label(this.getFieldEditorParent(), 0);
        Button addUserBt = new Button(this.getFieldEditorParent(), 8);
        addUserBt.setText(TomcatPluginResources.PREF_PAGE_MANAGER_ADDUSER);
        addUserBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TomcatManagerAppPreferencePage.this.addUserToTomcatUsers();
            }
        });
    }

    public void init(IWorkbench workbench) {
        if (!this.getPreferenceStore().contains("managerUrl")) {
            this.getPreferenceStore().setValue("managerUrl", this.DEFAULT_MANAGER_URL);
        }
    }

    public void addUserToTomcatUsers() {
        try {
            String endTag = "</tomcat-users>";
            String tomcatDir = TomcatLauncherPlugin.getDefault().getTomcatDir();
            File tomcatUsersFile = new File(String.valueOf(tomcatDir) + File.separator + "conf" + File.separator + "tomcat-users.xml");
            String tomcatUsersContent = FileUtil.readTextFile(tomcatUsersFile);
            String before = tomcatUsersContent.substring(0, tomcatUsersContent.indexOf(endTag));
            String username = this.userEditor.getStringValue();
            String manager = this.pwdEditor.getStringValue();
            String userTag = "  <user username=\"" + username + "\" password=\"" + manager + "\" roles=\"manager\"/>\n";
            FileUtil.toTextFile(tomcatUsersFile, String.valueOf(before) + userTag + endTag);
        }
        catch (IOException e) {
            TomcatLauncherPlugin.log(e);
        }
    }
}

