/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import com.collabnet.subversion.merge.wizards.MergeWizardStandardPage;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.core.history.Tags;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.SVNUrlWithPegRevision;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.GenerateChangeLogAction;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTreeViewer;
import org.tigris.subversion.subclipse.ui.history.HistoryFolder;
import org.tigris.subversion.subclipse.ui.history.HistoryTableProvider;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeWizardRevisionsPage
extends WizardPage {
    private MergeWizardStandardPage standardPage;
    private String fromUrl;
    private IDialogSettings settings;
    private SashForm sashForm;
    private HistoryTableProvider historyTableProvider;
    private ChangePathsTreeViewer changePathsViewer;
    private TableViewer tableHistoryViewer;
    private TextViewer textViewer;
    private ILogEntry[] entries;
    private IResource[] resources;
    private ISVNLocalResource svnResource;
    private ISVNRepositoryLocation repositoryLocation;
    private AliasManager tagManager;
    private ISVNRemoteResource remoteResource;
    private String message;
    private String pageName;
    private boolean pageShown;
    private GenerateChangeLogAction generateChangeLogAction;
    private Button generateChangeLogButton;
    private Label authorsLabel;
    private Combo authors;
    private String selectedAuthor;
    private boolean noEligibleEntries;
    private Map<SVNRevision.Number, List<IResource>> revisionToResource = new HashMap<SVNRevision.Number, List<IResource>>();
    private static final String ALL_AUTHORS = Messages.MergeWizardRevisionsPage_0;

    public MergeWizardRevisionsPage(String pageName, String title, ImageDescriptor titleImage, MergeWizardStandardPage standardPage, String message) {
        super(pageName, title, titleImage);
        this.standardPage = standardPage;
        this.message = message;
        this.pageName = pageName;
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public MergeWizardRevisionsPage(String pageName, String title, ImageDescriptor titleImage, MergeWizardStandardPage standardPage) {
        this(pageName, title, titleImage, standardPage, null);
    }

    public void createControl(Composite parent) {
        MergeWizard wizard = (MergeWizard)this.getWizard();
        this.resources = wizard.getResources();
        if (this.resources != null && this.resources.length > 0) {
            this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resources[0]);
            try {
                this.repositoryLocation = this.svnResource.getRepository();
            }
            catch (Exception exception) {}
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.sashForm = new SashForm(composite, 512);
        GridLayout sashLayout = new GridLayout();
        sashLayout.verticalSpacing = 0;
        sashLayout.marginHeight = 0;
        this.sashForm.setLayout((Layout)sashLayout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite historyGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout historyLayout = new GridLayout();
        historyLayout.verticalSpacing = 5;
        historyLayout.marginHeight = 0;
        historyGroup.setLayout((Layout)historyLayout);
        historyGroup.setLayoutData((Object)new GridData(1808));
        Composite authorsFilterGroup = new Composite(historyGroup, 0);
        GridLayout authorLayout = new GridLayout();
        authorLayout.verticalSpacing = 0;
        authorLayout.marginHeight = 0;
        authorLayout.numColumns = 2;
        authorsFilterGroup.setLayout((Layout)authorLayout);
        this.authorsLabel = new Label(authorsFilterGroup, 0);
        this.authorsLabel.setText(Messages.MergeWizardRevisionsPage_1);
        this.selectedAuthor = this.settings.get("MergeWizard.authorFilter");
        this.authors = new Combo(authorsFilterGroup, 2056);
        data = new GridData();
        data.widthHint = 200;
        this.authors.setLayoutData((Object)data);
        this.authors.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MergeWizardRevisionsPage.this.selectedAuthor = MergeWizardRevisionsPage.this.authors.getText();
                MergeWizardRevisionsPage.this.settings.put("MergeWizard.authorFilter", MergeWizardRevisionsPage.this.selectedAuthor);
                MergeWizardRevisionsPage.this.tableHistoryViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.historyTableProvider = new HistoryTableProvider(66338, this.pageName);
        this.historyTableProvider.setIncludeMergeRevisions(false);
        this.historyTableProvider.setIncludeTags(false);
        this.tableHistoryViewer = this.historyTableProvider.createTable(historyGroup);
        this.tableHistoryViewer.setFilters(new ViewerFilter[]{new AuthorViewFilter()});
        data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 100;
        this.tableHistoryViewer.getTable().setLayoutData((Object)data);
        this.tableHistoryViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (MergeWizardRevisionsPage.this.entries == null) {
                    return new ILogEntry[0];
                }
                return MergeWizardRevisionsPage.this.entries;
            }
        });
        this.tableHistoryViewer.setInput((Object)this.getUrl());
        this.tableHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MergeWizardRevisionsPage.this.generateChangeLogButton.setEnabled(!MergeWizardRevisionsPage.this.tableHistoryViewer.getSelection().isEmpty());
                MergeWizardRevisionsPage.this.setPageComplete(MergeWizardRevisionsPage.this.canFinish());
            }
        });
        this.tableHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MergeWizardRevisionsPage.this.setPageComplete(MergeWizardRevisionsPage.this.canFinish());
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    MergeWizardRevisionsPage.this.textViewer.setDocument((IDocument)new Document(""));
                    MergeWizardRevisionsPage.this.changePathsViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    MergeWizardRevisionsPage.this.textViewer.setDocument((IDocument)new Document(""));
                    MergeWizardRevisionsPage.this.changePathsViewer.setInput(null);
                    return;
                }
                LogEntry entry = (LogEntry)ss.getFirstElement();
                MergeWizardRevisionsPage.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                MergeWizardRevisionsPage.this.changePathsViewer.setCurrentLogEntry((ILogEntry)entry);
                MergeWizardRevisionsPage.this.changePathsViewer.setInput((Object)entry);
            }
        });
        this.generateChangeLogAction = new GenerateChangeLogAction(new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return MergeWizardRevisionsPage.this.tableHistoryViewer.getSelection();
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableHistoryViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                if (!MergeWizardRevisionsPage.this.tableHistoryViewer.getSelection().isEmpty()) {
                    menuMgr.add((IAction)new ToggleSelectionAction());
                    menuMgr.add((IAction)MergeWizardRevisionsPage.this.generateChangeLogAction);
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableHistoryViewer.getTable().setMenu(menu);
        Composite commentGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout commentLayout = new GridLayout();
        commentLayout.verticalSpacing = 0;
        commentLayout.marginHeight = 0;
        commentGroup.setLayout((Layout)commentLayout);
        commentGroup.setLayoutData((Object)new GridData(1808));
        this.textViewer = new TextViewer(commentGroup, 2826);
        data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 500;
        this.textViewer.getControl().setLayoutData((Object)data);
        Composite pathGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout pathLayout = new GridLayout();
        pathLayout.verticalSpacing = 0;
        pathLayout.marginHeight = 0;
        pathGroup.setLayout((Layout)pathLayout);
        pathGroup.setLayoutData((Object)new GridData(1808));
        ChangePathsTreeContentProvider contentProvider = new ChangePathsTreeContentProvider();
        this.changePathsViewer = new ChangePathsTreeViewer(pathGroup, (IContentProvider)contentProvider);
        this.setPageComplete(this.canFinish());
        if (this.message == null) {
            this.setMessage(Messages.MergeWizardRevisionsPage_specifyRevisions);
        } else {
            this.setMessage(this.message);
        }
        try {
            int[] weights = new int[]{this.settings.getInt("MergeWizardRevisionsPageWeights0"), this.settings.getInt("MergeWizardRevisionsPageWeights1"), this.settings.getInt("MergeWizardRevisionsPageWeights2")};
            this.sashForm.setWeights(weights);
        }
        catch (Exception exception) {}
        Composite buttonGroup = new Composite(composite, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonGroup.setLayout((Layout)buttonLayout);
        data = new GridData(64);
        buttonGroup.setLayoutData((Object)data);
        this.generateChangeLogButton = new Button(buttonGroup, 8);
        this.generateChangeLogButton.setText(Messages.MergeWizardRevisionsPage_generateChangeLog);
        this.generateChangeLogButton.setEnabled(false);
        this.generateChangeLogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeWizardRevisionsPage.this.generateChangeLogAction.run();
            }
        });
        this.setControl((Control)composite);
    }

    public boolean canFinish() {
        return this.getSelectedRevisions().length > 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (((MergeWizard)this.getWizard()).isRetrieveRevisionsMethodChanged() || this.fromUrl == null || !this.fromUrl.equals(this.standardPage.getFromUrl())) {
                this.refresh();
            }
            ((MergeWizard)this.getWizard()).setRetrieveRevisionsMethodChanged(false);
            if (!this.pageShown) {
                this.pageShown = true;
                this.historyTableProvider.setSortColumn(this.tableHistoryViewer, 0);
                this.historyTableProvider.setSortColumn(this.tableHistoryViewer, 0);
            }
            this.authorsLabel.setVisible(this.entries != null && this.entries.length > 0 && this.authors.getItemCount() > 2);
            this.authors.setVisible(this.entries != null && this.entries.length > 0 && this.authors.getItemCount() > 2);
        }
    }

    private void refresh() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.setTaskName(Messages.MergeWizardRevisionsPage_retrievingRemoteResource);
                    monitor.beginTask(Messages.MergeWizardRevisionsPage_retrievingRemoteResource, -1);
                    monitor.worked(1);
                    MergeWizardRevisionsPage.this.remoteResource = (ISVNRemoteResource)MergeWizardRevisionsPage.this.repositoryLocation.getRemoteFile(new SVNUrl(MergeWizardRevisionsPage.this.getUrl()));
                    monitor.done();
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
            }
        };
        this.setPageComplete(false);
        this.setErrorMessage(null);
        this.fromUrl = this.standardPage.getFromUrl();
        this.remoteResource = null;
        try {
            this.getContainer().run(true, false, runnable);
            if (this.remoteResource == null) {
                this.setErrorMessage(Messages.MergeWizardRevisionsPage_errorRetrievingRemoteResource);
                this.entries = new ILogEntry[0];
            } else {
                this.getLogEntries(false, false);
                if (this.noEligibleEntries) {
                    this.setErrorMessage(Messages.MergeWizardRevisionsPage_noEligibleRevisions);
                }
            }
        }
        catch (Exception e) {
            Activator.handleError(e);
            this.setErrorMessage(e.getMessage());
            this.entries = new ILogEntry[0];
        }
        if (this.tableHistoryViewer.getInput() == null) {
            this.tableHistoryViewer.setInput((Object)this.getUrl());
        } else {
            this.tableHistoryViewer.refresh();
        }
    }

    private void getLogEntries(boolean getAll, boolean getNext) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.setTaskName(Messages.MergeWizardRevisionsPage_retrievingRevisionLogInfo);
                    monitor.beginTask(Messages.MergeWizardRevisionsPage_retrievingRevisionLogInfo, 5);
                    if (SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote")) {
                        MergeWizardRevisionsPage.this.tagManager = new AliasManager(MergeWizardRevisionsPage.this.remoteResource.getUrl());
                    }
                    monitor.worked(1);
                    MergeWizardRevisionsPage.this.noEligibleEntries = false;
                    MergeWizardRevisionsPage.this.entries = MergeWizardRevisionsPage.this.getEligibleLogEntries(monitor);
                    monitor.worked(1);
                    if (MergeWizardRevisionsPage.this.entries != null && MergeWizardRevisionsPage.this.entries.length > 0) {
                        final TreeSet<String> set = new TreeSet<String>();
                        set.add(ALL_AUTHORS);
                        int i = 0;
                        while (i < MergeWizardRevisionsPage.this.entries.length) {
                            set.add(MergeWizardRevisionsPage.this.entries[i].getAuthor());
                            ++i;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                MergeWizardRevisionsPage.this.authors.setItems(set.toArray(new String[0]));
                                if (set.contains(MergeWizardRevisionsPage.this.selectedAuthor)) {
                                    MergeWizardRevisionsPage.this.authors.setText(MergeWizardRevisionsPage.this.selectedAuthor);
                                } else {
                                    MergeWizardRevisionsPage.this.authors.setText(ALL_AUTHORS);
                                }
                                MergeWizardRevisionsPage.this.authorsLabel.setVisible(set.size() > 2);
                                MergeWizardRevisionsPage.this.authors.setVisible(set.size() > 2);
                            }
                        });
                    } else {
                        MergeWizardRevisionsPage.this.noEligibleEntries = true;
                    }
                    monitor.worked(1);
                }
                catch (Exception e) {
                    Activator.handleError(e);
                    MergeWizardRevisionsPage.this.setErrorMessage(Messages.MergeWizardChangeSetRevisionsPage_errorRetrievingLogEntries);
                    MergeWizardRevisionsPage.this.entries = new ILogEntry[0];
                }
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (Exception e1) {
            Activator.handleError(e1);
        }
    }

    public boolean isPageComplete() {
        if (!this.standardPage.selectRevisions()) {
            return true;
        }
        return super.isPageComplete();
    }

    protected ILogEntry[] getEligibleLogEntries(IProgressMonitor monitor) throws TeamException {
        GetEligibleRevisionsCommand logCmd = new GetEligibleRevisionsCommand();
        logCmd.run(monitor);
        return logCmd.getLogEntries();
    }

    private SVNRevision.Number[] getAllRevisions() {
        SVNRevision.Number[] entryArray = new SVNRevision.Number[this.entries.length];
        int i = 0;
        while (i < this.entries.length) {
            entryArray[i] = this.entries[i].getRevision();
            ++i;
        }
        return entryArray;
    }

    private SVNRevision.Number[] getSelectedRevisions() {
        ArrayList<SVNRevision.Number> selectedEntries = new ArrayList<SVNRevision.Number>();
        TableItem[] items = this.tableHistoryViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                ILogEntry entry = (ILogEntry)items[i].getData();
                selectedEntries.add(entry.getRevision());
            }
            ++i;
        }
        SVNRevision.Number[] entryArray = new SVNRevision.Number[selectedEntries.size()];
        selectedEntries.toArray(entryArray);
        return entryArray;
    }

    public ILogEntry[] getSelectedLogEntries() {
        ArrayList<ILogEntry> selectedEntries = new ArrayList<ILogEntry>();
        TableItem[] items = this.tableHistoryViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                ILogEntry entry = (ILogEntry)items[i].getData();
                selectedEntries.add(entry);
            }
            ++i;
        }
        ILogEntry[] entryArray = new ILogEntry[selectedEntries.size()];
        selectedEntries.toArray(entryArray);
        return entryArray;
    }

    public SVNRevisionRange[] getRevisions() {
        return SVNRevisionRange.getRevisions((SVNRevision.Number[])this.getSelectedRevisions(), (SVNRevision.Number[])this.getAllRevisions());
    }

    public Map<SVNRevision.Number, List<IResource>> getRevisionToResource() {
        return this.revisionToResource;
    }

    public void dispose() {
        if (this.pageShown) {
            int[] weights = this.sashForm.getWeights();
            int i = 0;
            while (i < weights.length) {
                this.settings.put("MergeWizardRevisionsPageWeights" + i, weights[i]);
                ++i;
            }
        }
        super.dispose();
    }

    private String getUrl() {
        if (this.fromUrl != null) {
            try {
                SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(new SVNUrl(this.fromUrl));
                SVNUrl svnUrl = svnUrlWithPegRevision.getUrl();
                if (svnUrl != null) {
                    return svnUrl.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.fromUrl;
    }

    class AuthorViewFilter
    extends ViewerFilter {
        AuthorViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (MergeWizardRevisionsPage.this.authors.isVisible() && element instanceof ILogEntry && MergeWizardRevisionsPage.this.selectedAuthor != null && !MergeWizardRevisionsPage.this.selectedAuthor.equals(ALL_AUTHORS)) {
                return ((ILogEntry)element).getAuthor().equals(MergeWizardRevisionsPage.this.selectedAuthor);
            }
            return true;
        }
    }

    static class ChangePathsTreeContentProvider
    implements ITreeContentProvider {
        ChangePathsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HistoryFolder) {
                return ((HistoryFolder)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HistoryFolder) {
                HistoryFolder folder = (HistoryFolder)element;
                return folder.getChildren().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ILogEntry logEntry = (ILogEntry)inputElement;
            return this.getGroups(logEntry.getLogEntryChangePaths());
        }

        private Object[] getGroups(LogEntryChangePath[] changePaths) {
            HashSet<String> folderNames = new HashSet<String>();
            int i = 0;
            while (i < changePaths.length) {
                folderNames.add(this.getFolderName(changePaths[i]));
                ++i;
            }
            TreeMap<String, HistoryFolder> folders = new TreeMap<String, HistoryFolder>();
            int i2 = 0;
            while (i2 < changePaths.length) {
                HistoryFolder folder;
                LogEntryChangePath changePath = changePaths[i2];
                String path = changePath.getPath();
                if (folderNames.contains(path)) {
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(changePath);
                        folders.put(path, folder);
                    }
                } else {
                    path = this.getFolderName(changePath);
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(path);
                        folders.put(path, folder);
                    }
                    folder.add(changePath);
                }
                ++i2;
            }
            return folders.values().toArray(new Object[folders.size()]);
        }

        private String getFolderName(LogEntryChangePath changePath) {
            String path = changePath.getPath();
            int n = path.lastIndexOf(47);
            return n > -1 ? path.substring(0, n) : path;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class GetEligibleRevisionsCommand
    implements ISVNCommand {
        private ILogEntry[] logEntries;

        public void run(IProgressMonitor aMonitor) throws SVNException {
            this.logEntries = null;
            IProgressMonitor monitor = Policy.monitorFor((IProgressMonitor)aMonitor);
            int taskLength = MergeWizardRevisionsPage.this.settings.getBoolean("MergeWizard.retrieveEligibleRevisionsSeparately") ? MergeWizardRevisionsPage.this.standardPage.getUrls().length : -1;
            monitor.beginTask(Messages.MergeWizardRevisionsPage_retrievingLogEntries, taskLength);
            ISVNLogMessage[] logMessages = null;
            try {
                try {
                    ISVNClientAdapter client = MergeWizardRevisionsPage.this.remoteResource.getRepository().getSVNClient();
                    SVNProviderPlugin.disableConsoleLogging();
                    if (MergeWizardRevisionsPage.this.resources.length > 1 && MergeWizardRevisionsPage.this.settings.getBoolean("MergeWizard.retrieveEligibleRevisionsSeparately")) {
                        logMessages = this.getCombinedLogMessages(client, monitor);
                    } else {
                        String commonRoot = ((MergeWizard)MergeWizardRevisionsPage.this.getWizard()).getCommonRoot();
                        SVNUrl rootUrl = new SVNUrl(commonRoot);
                        logMessages = client.getMergeinfoLog(0, rootUrl, SVNRevision.HEAD, MergeWizardRevisionsPage.this.remoteResource.getUrl(), SVNRevision.HEAD, !SVNProviderPlugin.getPlugin().getSVNClientManager().isFetchChangePathOnDemand());
                    }
                    this.logEntries = MergeWizardRevisionsPage.this.remoteResource.isFolder() ? LogEntry.createLogEntriesFrom((ISVNRemoteFolder)((ISVNRemoteFolder)MergeWizardRevisionsPage.this.remoteResource), (ISVNLogMessage[])logMessages, (Tags[])this.getTags(logMessages)) : LogEntry.createLogEntriesFrom((ISVNRemoteFile)((ISVNRemoteFile)MergeWizardRevisionsPage.this.remoteResource), (ISVNLogMessage[])logMessages, (Tags[])this.getTags(logMessages), (SVNUrl[])this.getUrls(logMessages));
                }
                catch (Exception e) {
                    throw SVNException.wrapException((Exception)e);
                }
            }
            finally {
                SVNProviderPlugin.enableConsoleLogging();
                monitor.done();
            }
        }

        private ISVNLogMessage[] getCombinedLogMessages(ISVNClientAdapter client, IProgressMonitor monitor) throws Exception {
            ArrayList<SVNRevision.Number> revisions = new ArrayList<SVNRevision.Number>();
            ArrayList<ISVNLogMessage> logMessages = new ArrayList<ISVNLogMessage>();
            SVNUrl[] urls = MergeWizardRevisionsPage.this.standardPage.getUrls();
            int i = 0;
            while (i < MergeWizardRevisionsPage.this.resources.length) {
                IResource resource = MergeWizardRevisionsPage.this.resources[i];
                monitor.subTask(resource.getName());
                SVNUrl remoteUrl = urls[i];
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                SVNUrl url = svnResource.getUrl();
                ISVNLogMessage[] resourceLogMessages = null;
                try {
                    resourceLogMessages = client.getMergeinfoLog(0, url, SVNRevision.HEAD, remoteUrl, SVNRevision.HEAD, !SVNProviderPlugin.getPlugin().getSVNClientManager().isFetchChangePathOnDemand());
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                if (resourceLogMessages != null) {
                    ISVNLogMessage[] iSVNLogMessageArray = resourceLogMessages;
                    int n = resourceLogMessages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ArrayList<IResource> lst;
                        ISVNLogMessage logMessage = iSVNLogMessageArray[n2];
                        if (!revisions.contains(logMessage.getRevision())) {
                            revisions.add(logMessage.getRevision());
                            logMessages.add(logMessage);
                        }
                        if ((lst = (ArrayList<IResource>)MergeWizardRevisionsPage.this.revisionToResource.get(logMessage.getRevision())) == null) {
                            lst = new ArrayList<IResource>(MergeWizardRevisionsPage.this.resources.length);
                            MergeWizardRevisionsPage.this.revisionToResource.put(logMessage.getRevision(), lst);
                        }
                        lst.add(resource);
                        ++n2;
                    }
                }
                monitor.worked(1);
                ++i;
            }
            ISVNLogMessage[] logMessageArray = new ISVNLogMessage[logMessages.size()];
            logMessages.toArray(logMessageArray);
            return logMessageArray;
        }

        private SVNUrl[] fillUrlsWith(SVNUrl[] urls, SVNUrl url) {
            int i = 0;
            while (i < urls.length) {
                urls[i] = url;
                ++i;
            }
            return urls;
        }

        private SVNUrl[] getUrls(ISVNLogMessage[] logMessages) {
            SVNUrl urlCopyPath;
            SVNUrl urlChangedPath;
            int j;
            ISVNLogMessageChangePath[] changePaths;
            SVNUrl[] urls = new SVNUrl[logMessages.length];
            SVNUrl rootRepositoryUrl = MergeWizardRevisionsPage.this.remoteResource.getRepository().getRepositoryRoot();
            if (rootRepositoryUrl == null) {
                return this.fillUrlsWith(urls, MergeWizardRevisionsPage.this.remoteResource.getUrl());
            }
            int indexRemote = -1;
            int i = 0;
            while (i < logMessages.length) {
                if (logMessages[i].getRevision().equals((Object)MergeWizardRevisionsPage.this.remoteResource.getLastChangedRevision())) {
                    indexRemote = i;
                    break;
                }
                ++i;
            }
            if (indexRemote > -1) {
                urls[indexRemote] = MergeWizardRevisionsPage.this.remoteResource.getUrl();
            }
            SVNUrl currentUrl = MergeWizardRevisionsPage.this.remoteResource.getUrl();
            int i2 = indexRemote + 1;
            while (i2 < logMessages.length) {
                changePaths = logMessages[i2].getChangedPaths();
                j = 0;
                while (j < changePaths.length) {
                    urlChangedPath = rootRepositoryUrl.appendPath(changePaths[j].getPath());
                    if (currentUrl.equals((Object)urlChangedPath)) {
                        urls[i2] = currentUrl;
                        break;
                    }
                    if (changePaths[j].getCopySrcPath() != null && currentUrl.equals((Object)(urlCopyPath = rootRepositoryUrl.appendPath(changePaths[j].getCopySrcPath())))) {
                        urls[i2] = currentUrl = rootRepositoryUrl.appendPath(changePaths[j].getPath());
                        break;
                    }
                    ++j;
                }
                if (urls[i2] == null) {
                    return this.fillUrlsWith(urls, MergeWizardRevisionsPage.this.remoteResource.getUrl());
                }
                ++i2;
            }
            currentUrl = MergeWizardRevisionsPage.this.remoteResource.getUrl();
            i2 = indexRemote - 1;
            while (i2 >= 0) {
                changePaths = logMessages[i2].getChangedPaths();
                j = 0;
                while (j < changePaths.length) {
                    urlChangedPath = rootRepositoryUrl.appendPath(changePaths[j].getPath());
                    if (currentUrl.equals((Object)urlChangedPath)) {
                        urls[i2] = currentUrl;
                        if (changePaths[j].getCopySrcPath() == null) break;
                        currentUrl = urlCopyPath = rootRepositoryUrl.appendPath(changePaths[j].getCopySrcPath());
                        break;
                    }
                    ++j;
                }
                if (urls[i2] == null) {
                    return this.fillUrlsWith(urls, MergeWizardRevisionsPage.this.remoteResource.getUrl());
                }
                --i2;
            }
            return urls;
        }

        private Tags[] getTags(ISVNLogMessage[] logMessages) throws NumberFormatException {
            Tags[] tags = new Tags[logMessages.length];
            int i = 0;
            while (i < logMessages.length) {
                if (MergeWizardRevisionsPage.this.tagManager != null) {
                    String rev = logMessages[i].getRevision().toString();
                    int revNo = Integer.parseInt(rev);
                    tags[i] = new Tags(MergeWizardRevisionsPage.this.tagManager.getTags(revNo));
                }
                ++i;
            }
            return tags;
        }

        public ILogEntry[] getLogEntries() {
            return this.logEntries;
        }
    }

    private class ToggleSelectionAction
    extends Action {
        public ToggleSelectionAction() {
            this.setText("Toggle selection");
        }

        public void run() {
            TableItem[] items = MergeWizardRevisionsPage.this.tableHistoryViewer.getTable().getSelection();
            int i = 0;
            while (i < items.length) {
                items[i].setChecked(!items[i].getChecked());
                ++i;
            }
            MergeWizardRevisionsPage.this.setPageComplete(MergeWizardRevisionsPage.this.canFinish());
        }
    }
}

