/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resourcesListeners;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.resources.SVNMoveDeleteHook;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class RevertResourceManager
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        final ArrayList addedFileResources = new ArrayList();
        try {
            IResourceDelta[] resources;
            ISVNLocalResource[] revertResources;
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().getType() == 1) {
                        if (delta.getKind() == 1 || delta.getKind() == 4) {
                            addedFileResources.add(delta);
                        } else if (delta.getKind() == 2) {
                            SVNMoveDeleteHook.removeFromDeletedFileList((IFile)delta.getResource());
                        }
                    }
                    return true;
                }
            });
            if (!addedFileResources.isEmpty() && (revertResources = this.processResources(resources = addedFileResources.toArray(new IResourceDelta[addedFileResources.size()]))).length > 0) {
                new RevertWorkspaceJob(revertResources).schedule(500L);
            }
        }
        catch (CoreException e) {
            SVNProviderPlugin.log(e.getStatus());
        }
    }

    private ISVNLocalResource[] processResources(IResourceDelta[] resources) throws CoreException {
        ArrayList<ISVNLocalResource> revertedResources = new ArrayList<ISVNLocalResource>();
        int i = 0;
        while (i < resources.length) {
            ISVNLocalFile res;
            IResource resource = resources[i].getResource();
            if (resource.getType() == 1 && (res = SVNWorkspaceRoot.getSVNFileFor((IFile)resource)).getFile().exists()) {
                boolean deleted;
                if (resources[i].getKind() == 1) {
                    deleted = res.getStatus().isDeleted();
                } else {
                    deleted = SVNMoveDeleteHook.isDeleted((IFile)resource);
                    if (deleted) {
                        SVNMoveDeleteHook.removeFromDeletedFileList((IFile)resource);
                    }
                }
                if (deleted) {
                    revertedResources.add(res);
                }
                ISVNLocalFolder parentFolder = res.getParent();
                while (parentFolder != null) {
                    if (!parentFolder.getStatus().isDeleted() || revertedResources.contains(parentFolder)) break;
                    revertedResources.add(parentFolder);
                    if (parentFolder.getParent() == null) break;
                    parentFolder = parentFolder.getParent();
                }
            }
            ++i;
        }
        return revertedResources.toArray(new ISVNLocalResource[revertedResources.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void revert(ISVNLocalResource resource) throws SVNException {
        try {
            try {
                ISVNClientAdapter svnClient = resource.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                svnClient.revert(resource.getFile(), false);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            OperationManager.getInstance().endOperation();
            throw throwable;
        }
        {
            Object var3_6 = null;
            OperationManager.getInstance().endOperation();
            return;
        }
    }

    private class RevertWorkspaceJob
    extends WorkspaceJob {
        private final ISVNLocalResource[] resources;

        public RevertWorkspaceJob(ISVNLocalResource[] resources) {
            super(Policy.bind("RevertResourceManager.jobName"));
            this.resources = resources;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void revertResources(ISVNLocalResource[] resources, IProgressMonitor monitor) throws SVNException {
            monitor.beginTask(Policy.bind("RevertResourceManager.reverting"), resources.length);
            int i = 0;
            while (i < resources.length) {
                if (monitor.isCanceled()) break;
                if (resources[i] instanceof ISVNLocalFile) {
                    ISVNLocalFile res = (ISVNLocalFile)resources[i];
                    File file = res.getFile().getAbsoluteFile();
                    File tmp = new File(String.valueOf(res.getFile().getAbsolutePath()) + ".svntmp");
                    if (tmp.exists()) {
                        tmp.delete();
                    }
                    if (!file.renameTo(tmp)) throw SVNException.wrapException(new IllegalStateException("Could not rename " + file + " to " + tmp));
                    RevertResourceManager.this.revert(res);
                    if (!file.delete()) {
                        throw SVNException.wrapException(new IllegalStateException("Could not remove " + file));
                    }
                    if (!tmp.renameTo(file)) {
                        throw SVNException.wrapException(new IllegalStateException("Could not rename " + tmp + " to " + file));
                    }
                } else {
                    RevertResourceManager.this.revert(resources[i]);
                }
                monitor.worked(1);
                ++i;
            }
            monitor.done();
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this.revertResources(this.resources, monitor);
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

