/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.resources.BaseResource;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;

public class BaseFolder
extends BaseResource
implements ISVNRemoteFolder {
    public BaseFolder(IResource resource, LocalResourceStatus localResourceStatus) {
        super(resource, localResourceStatus);
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isFolder() {
        return true;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        return null;
    }

    public ISVNRemoteResource[] members(IProgressMonitor progress) throws TeamException {
        return this.getMembers(progress);
    }

    public ISVNResource[] members(IProgressMonitor monitor, int flags) throws SVNException {
        ArrayList<ISVNRemoteResource> result = new ArrayList<ISVNRemoteResource>();
        ISVNRemoteResource[] resources = this.getMembers(monitor);
        if ((flags & 0x20) == 0 && (flags & 0x40) == 1) {
            return new ISVNResource[0];
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        int i = 0;
        while (i < resources.length) {
            ISVNRemoteResource svnResource = resources[i];
            if ((includeFiles && !svnResource.isFolder() || includeFolders && svnResource.isFolder()) && includeManaged) {
                result.add(svnResource);
            }
            ++i;
        }
        return result.toArray(new ISVNResource[result.size()]);
    }

    protected ISVNRemoteResource[] getMembers(IProgressMonitor monitor) throws SVNException {
        ISVNRemoteResource[] iSVNRemoteResourceArray;
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.getMembers"), 100);
        try {
            GetStatusCommand c = new GetStatusCommand(this.localResourceStatus.getRepository(), this.resource, false, true);
            c.run(monitor);
            LocalResourceStatus[] statuses = c.getLocalResourceStatuses();
            ArrayList<BaseResource> baseChildren = new ArrayList<BaseResource>(statuses.length);
            int i = 0;
            while (i < statuses.length) {
                if (!this.localResourceStatus.getFile().equals(statuses[i].getFile()) && statuses[i].hasRemote() && statuses[i].getUrlString() != null && !statuses[i].getUrlString().equals(this.localResourceStatus.getUrlString())) {
                    baseChildren.add(BaseResource.from(SVNWorkspaceRoot.getResourceFor(this.resource, statuses[i]), statuses[i]));
                }
                ++i;
            }
            iSVNRemoteResourceArray = baseChildren.toArray(new ISVNRemoteResource[baseChildren.size()]);
            Object var7_8 = null;
        }
        catch (CoreException coreException) {
            try {
                throw new SVNException((IStatus)new SVNStatus(4, -17, Policy.bind("RemoteFolder.doesNotExist", this.getRepositoryRelativePath())));
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                progress.done();
                throw throwable;
            }
        }
        progress.done();
        return iSVNRemoteResourceArray;
    }

    public void createRemoteFolder(String folderName, String message, IProgressMonitor monitor) throws SVNException {
        throw new SVNException("Cannot create remote folder on Base Folder");
    }

    public void refresh() {
    }
}

