/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SwitchToUrlCommand
implements ISVNCommand {
    private IResource resource;
    private SVNUrl svnUrl;
    private SVNRevision svnRevision;
    private SVNWorkspaceRoot root;
    private int depth = -2;
    private boolean setDepth = false;
    private boolean ignoreExternals = false;
    private boolean force = true;

    public SwitchToUrlCommand(SVNWorkspaceRoot root, IResource resource, SVNUrl svnUrl, SVNRevision svnRevision) {
        this.root = root;
        this.resource = resource;
        this.svnUrl = svnUrl;
        this.svnRevision = svnRevision;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        IProgressMonitor subPm = Policy.infiniteSubMonitorFor(monitor, 100);
        try {
            try {
                subPm.beginTask(null, 100);
                ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(subPm));
                File file = this.resource.getLocation().toFile();
                SVNRevision pegRevision = null;
                pegRevision = SVNRevision.HEAD;
                svnClient.switchToUrl(file, this.svnUrl, this.svnRevision, pegRevision, this.depth, this.setDepth, this.ignoreExternals, this.force);
                try {
                    this.resource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            OperationManager.getInstance().endOperation();
            subPm.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
            OperationManager.getInstance().endOperation();
        }
        subPm.done();
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setSetDepth(boolean setDepth) {
        this.setDepth = setDepth;
    }

    public void setIgnoreExternals(boolean ignoreExternals) {
        this.ignoreExternals = ignoreExternals;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

