/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.io.File;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public class RevertResourcesCommand
implements ISVNCommand {
    private final SVNWorkspaceRoot root;
    private final IResource[] resources;
    private IResource[] resourcesToRevert;
    private boolean recurse = false;
    private IProject project;
    public static final Comparator resourceComparator = new Comparator(){
        Collator collator = Collator.getInstance();

        public boolean equals(Object obj) {
            return false;
        }

        public int compare(Object o1, Object o2) {
            IResource resource0 = (IResource)o1;
            IResource resource1 = (IResource)o2;
            return this.collator.compare(resource0.getFullPath().toString(), resource1.getFullPath().toString());
        }
    };

    public RevertResourcesCommand(SVNWorkspaceRoot root, IResource[] resources) {
        this.root = root;
        this.resources = resources;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws SVNException {
        Arrays.sort(this.resources, resourceComparator);
        try {
            try {
                LocalResourceStatus status;
                int i;
                final OperationManager operationManager = OperationManager.getInstance();
                ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
                operationManager.beginOperation(svnClient);
                if (this.recurse && this.resourcesToRevert != null) {
                    i = 0;
                    while (i < this.resourcesToRevert.length) {
                        if (this.project == null || this.resourcesToRevert[i].getProject().equals((Object)this.project)) {
                            try {
                                Util.saveLocalHistory(this.resourcesToRevert[i]);
                            }
                            catch (CoreException e) {
                                SVNProviderPlugin.log(4, e.getMessage(), e);
                            }
                            status = SVNWorkspaceRoot.getSVNResourceFor(this.resourcesToRevert[i]).getStatus();
                            if (!(this.resourcesToRevert[i].getType() == 2 && status.isAdded() || status.isManaged())) {
                                try {
                                    this.resourcesToRevert[i].delete(true, monitor);
                                }
                                catch (CoreException ex) {
                                    throw SVNException.wrapException(ex);
                                }
                            }
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < this.resources.length) {
                    status = SVNWorkspaceRoot.getSVNResourceFor(this.resources[i]).getStatus();
                    if (this.resources[i].getType() == 2 && status.isAdded()) {
                        svnClient.revert(this.resources[i].getLocation().toFile(), true);
                        monitor.worked(100);
                        try {
                            this.resources[i].accept(new IResourceVisitor(){

                                public boolean visit(IResource aResource) {
                                    if (aResource.getType() == 2) {
                                        operationManager.onNotify(aResource.getLocation().toFile(), SVNNodeKind.UNKNOWN);
                                    }
                                    return true;
                                }
                            }, 2, false);
                        }
                        catch (CoreException e) {
                            SVNProviderPlugin.log(2, "", e);
                        }
                        String baseFullPath = this.resources[i].getFullPath().addTrailingSeparator().toString();
                        while (i < this.resources.length - 1 && this.resources[i + 1].getFullPath().toString().startsWith(baseFullPath)) {
                            monitor.worked(100);
                            ++i;
                        }
                    } else {
                        if (!status.isManaged()) {
                            try {
                                this.resources[i].delete(true, monitor);
                            }
                            catch (CoreException ex) {
                                throw SVNException.wrapException(ex);
                            }
                        }
                        if (!this.recurse) {
                            try {
                                Util.saveLocalHistory(this.resources[i]);
                            }
                            catch (CoreException e) {
                                SVNProviderPlugin.log(4, e.getMessage(), e);
                            }
                        }
                        File path = this.resources[i].getLocation().toFile();
                        svnClient.revert(path, this.recurse);
                        if (this.resources[i].getType() != 1) {
                            operationManager.onNotify(path, SVNNodeKind.UNKNOWN);
                        }
                        monitor.worked(100);
                    }
                    ++i;
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            OperationManager.getInstance().endOperation();
            monitor.done();
            throw throwable;
        }
        {
            Object var7_15 = null;
            OperationManager.getInstance().endOperation();
        }
        monitor.done();
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setResourcesToRevert(IResource[] resourcesToRevert) {
        this.resourcesToRevert = resourcesToRevert;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

