/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNClientManager;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProjectSetCapability;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNTeamProviderType
extends RepositoryProviderType {
    protected static AutoShareJob autoShareJob;

    private static synchronized AutoShareJob getAutoShareJob() {
        if (autoShareJob == null) {
            autoShareJob = new AutoShareJob();
            autoShareJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!autoShareJob.isQueueEmpty()) {
                        autoShareJob.schedule();
                    }
                }
            });
            autoShareJob.setSystem(true);
            autoShareJob.setPriority(20);
            autoShareJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        return autoShareJob;
    }

    public boolean supportsProjectSetImportRelocation() {
        return false;
    }

    public ProjectSetCapability getProjectSetCapability() {
        return new SVNProjectSetCapability();
    }

    private static synchronized void createAutoAddJob(IProject project) {
        AutoAddJob j = new AutoAddJob(project);
        j.setSystem(true);
        j.setPriority(20);
        j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        j.schedule();
    }

    public void metaFilesDetected(IProject project, IContainer[] containers) {
        SVNProviderPlugin plugin = SVNProviderPlugin.getPlugin();
        boolean isProject = false;
        boolean isSvnProject = plugin.isManagedBySubversion((IContainer)project);
        int i = 0;
        while (i < containers.length) {
            IContainer container = containers[i];
            IContainer svnDir = null;
            if (!isProject && container.getType() == 4) {
                isProject = true;
            }
            if (plugin.isAdminDirectory(container.getName())) {
                svnDir = container;
            } else {
                IResource resource = container.findMember(plugin.getAdminDirectoryName());
                if (resource != null && resource.getType() != 1) {
                    svnDir = (IContainer)resource;
                }
            }
            try {
                if (svnDir != null && !svnDir.isTeamPrivateMember()) {
                    if (!isSvnProject) {
                        if (plugin.isManagedBySubversion(svnDir.getParent())) {
                            svnDir.setTeamPrivateMember(true);
                        }
                    } else {
                        svnDir.setTeamPrivateMember(true);
                    }
                }
            }
            catch (CoreException e) {
                SVNProviderPlugin.log(4, "Could not flag meta-files as team-private for " + svnDir.getFullPath(), e);
            }
            ++i;
        }
        if (!isProject) {
            return;
        }
        if (!SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("share_nested_projects") && this.isNestedProject(project)) {
            return;
        }
        if (isSvnProject) {
            SVNTeamProviderType.getAutoShareJob().share(project);
        } else {
            IPath parentDir = project.getLocation().append("../");
            if (plugin.isManagedBySubversion(parentDir)) {
                SVNTeamProviderType.createAutoAddJob(project);
            }
        }
    }

    public Subscriber getSubscriber() {
        return SVNWorkspaceSubscriber.getInstance();
    }

    private boolean isNestedProject(IProject testProject) {
        IPath testProjectLocation = testProject.getLocation();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IPath projectLocation;
            IProject project = projects[i];
            if (!project.equals((Object)testProject) && (projectLocation = project.getLocation()) != null && projectLocation.isPrefixOf(testProjectLocation)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class AutoShareJob
    extends Job {
        List projectsToShare = new ArrayList();

        AutoShareJob() {
            super("Auto-sharing imported subversion projects");
        }

        public boolean isQueueEmpty() {
            return this.projectsToShare.isEmpty();
        }

        public boolean shouldSchedule() {
            return !this.isQueueEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            List list = this.projectsToShare;
            synchronized (list) {
                Iterator iter = this.projectsToShare.iterator();
                while (iter.hasNext()) {
                    IProject project = (IProject)iter.next();
                    if (!RepositoryProvider.isShared((IProject)project)) continue;
                    iter.remove();
                }
                return !this.projectsToShare.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void share(IProject project) {
            if (!RepositoryProvider.isShared((IProject)project)) {
                List list = this.projectsToShare;
                synchronized (list) {
                    if (!this.projectsToShare.contains(project)) {
                        SVNWorkspaceRoot.setManagedBySubclipse(project);
                        this.projectsToShare.add(project);
                    }
                }
                if (this.getState() == 0 && !this.isQueueEmpty()) {
                    this.schedule();
                }
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProject next = null;
            next = this.getNextProject();
            monitor.beginTask(null, -1);
            while (next != null) {
                this.autoconnectSVNProject(next, Policy.subMonitorFor(monitor, -1));
                next = this.getNextProject();
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IProject getNextProject() {
            IProject next = null;
            List list = this.projectsToShare;
            synchronized (list) {
                if (!this.projectsToShare.isEmpty()) {
                    next = (IProject)this.projectsToShare.remove(0);
                }
            }
            return next;
        }

        private void autoconnectSVNProject(IProject project, IProgressMonitor monitor) {
            try {
                SVNWorkspaceRoot.setSharing(project, monitor);
            }
            catch (TeamException e) {
                SVNProviderPlugin.log(4, "Could not auto-share project " + project.getName(), e);
            }
        }
    }

    public static class AutoAddJob
    extends Job {
        static final int MAX_RETRIES = 10;
        int reschedCount = 0;
        final IProject project;

        protected AutoAddJob(IProject project) {
            super("Auto-adding newly created project to subversion: " + project.getName());
            this.project = project;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            block10: {
                IStatus iStatus;
                block9: {
                    IStatus iStatus2;
                    block8: {
                        monitor.beginTask(null, -1);
                        try {
                            try {
                                SVNProviderPlugin plugin = SVNProviderPlugin.getPlugin();
                                if (plugin == null || plugin.getSimpleDialogsHelper() == null) {
                                    if (++this.reschedCount > 10) {
                                        String errorString = "Subclipse core and/or ui didn't come up in 10 retries, failing.";
                                        System.err.println(errorString);
                                        throw new SVNException(errorString);
                                    }
                                    this.schedule(1000L);
                                    iStatus2 = Status.OK_STATUS;
                                    Object var6_9 = null;
                                    break block8;
                                }
                                if (!plugin.getSimpleDialogsHelper().promptYesNo("Auto-add " + this.project.getName() + " to source control", "The new project \"" + this.project.getName() + "\" was created in a subversion " + "controlled directory.\n\n" + "Would you like to automatically add it to source control?", true)) {
                                    iStatus = Status.OK_STATUS;
                                    break block9;
                                }
                                SVNClientManager svnClientManager = plugin.getSVNClientManager();
                                ISVNClientAdapter client = svnClientManager.getSVNClient();
                                File file = this.project.getLocation().toFile();
                                client.addDirectory(file, false);
                                RepositoryProvider.map((IProject)this.project, (String)SVNProviderPlugin.getTypeId());
                                plugin.getStatusCacheManager().refreshStatus((IContainer)this.project, true);
                                break block10;
                            }
                            catch (Exception e) {
                                SVNProviderPlugin.log(4, "Could not auto-add project " + this.project.getName(), e);
                                IStatus iStatus3 = Status.CANCEL_STATUS;
                                Object var6_11 = null;
                                monitor.done();
                                return iStatus3;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return iStatus2;
                }
                Object var6_10 = null;
                monitor.done();
                return iStatus;
            }
            Object var6_13 = null;
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

