/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.text.MessageFormat;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SVNAdmin;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;

public class JhlClientAdapter
extends AbstractJhlClientAdapter {
    private SVNAdmin svnAdmin;

    public JhlClientAdapter() {
        this.svnClient = new SVNClient();
        this.svnAdmin = new SVNAdmin();
        this.notificationHandler = new JhlNotificationHandler();
        this.progressListener = new JhlProgressListener();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
        this.svnClient.setProgressListener((ProgressListener)this.progressListener);
    }

    public boolean isThreadsafe() {
        return true;
    }

    public static boolean isAvailable() {
        return JhlClientAdapterFactory.isAvailable();
    }

    public static String getLibraryLoadErrors() {
        return JhlClientAdapterFactory.getLibraryLoadErrors();
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        try {
            String fsType = repositoryType == null ? "fsfs" : repositoryType;
            this.notificationHandler.setCommand(23);
            String target = JhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine(MessageFormat.format("create --fstype {0} {1}", fsType, target));
            this.svnAdmin.create(target, false, false, null, fsType);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public static void enableLogging(int logLevel, File filePath) {
        SVNClient.enableLogging((int)logLevel, (String)JhlClientAdapter.fileToSVNPath(filePath, false));
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public String getNativeLibraryVersionString() {
        return this.svnClient.getVersion().toString();
    }
}

