/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorInput;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.editors.RevisionGraphEditorInput;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;

public class ViewGraphAction
extends WorkbenchWindowAction {
    private IResource selectedResource;

    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    IResource[] resources = ViewGraphAction.this.getSelectedResources();
                    try {
                        if (resources.length > 0) {
                            ViewGraphAction.this.getTargetPage().openEditor((IEditorInput)new RevisionGraphEditorInput(resources[0]), "org.tigris.subversion.subclipse.graph.editors.revisionGraphEditor");
                        }
                    }
                    catch (Exception e) {
                        Activator.handleError(e);
                        Activator.showErrorDialog(ViewGraphAction.this.getErrorTitle(), e);
                    }
                }
            }, false, 2);
        }
    }

    protected String getErrorTitle() {
        return Policy.bind((String)"ViewGraphAction.viewGraph");
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForCopiedResources() {
        return true;
    }

    protected IResource[] getSelectedResources() {
        if (this.selectedResource != null) {
            IResource[] selectedResources = new IResource[]{this.selectedResource};
            return selectedResources;
        }
        return super.getSelectedResources();
    }

    public void setSelectedResource(IResource selectedResource) {
        this.selectedResource = selectedResource;
    }
}

