/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.settings.CommentProperties;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.subclipse.ui.wizards.BranchTagWizard;
import org.tigris.subversion.subclipse.ui.wizards.IClosableWizard;
import org.tigris.subversion.subclipse.ui.wizards.SVNWizardPage;

public class BranchTagWizardCommentPage
extends SVNWizardPage {
    protected CommitCommentArea commitCommentArea;
    private Text issueText;
    private CommentProperties commentProperties;
    private ProjectProperties projectProperties;
    protected Button switchAfterBranchTagCheckBox;
    private IResource resource;
    private boolean visited = false;

    public BranchTagWizardCommentPage() {
        super("commentPage", Policy.bind("BranchTagWizardCommentPage.heading"), SVNUIPlugin.getPlugin().getImageDescriptor("wizban/svn_wizban.png"), Policy.bind("BranchTagWizardCommentPage.message"));
    }

    public void createControl(Composite parent) {
        this.resource = ((BranchTagWizard)this.getWizard()).getResource();
        if (this.resource == null) {
            this.commitCommentArea = new CommitCommentArea(null, null, Policy.bind("BranchTagDialog.enterComment"), this.commentProperties);
        } else {
            try {
                this.commentProperties = CommentProperties.getCommentProperties(this.resource);
                this.projectProperties = ProjectProperties.getProjectProperties(this.resource);
            }
            catch (SVNException sVNException) {}
            this.commitCommentArea = new CommitCommentArea(null, null, Policy.bind("BranchTagDialog.enterComment"), this.commentProperties);
            if (this.commentProperties != null && this.commentProperties.getMinimumLogMessageSize() != 0) {
                ModifyListener modifyListener = new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        BranchTagWizardCommentPage.this.setPageComplete(BranchTagWizardCommentPage.this.canFinish());
                    }
                };
                this.commitCommentArea.setModifyListener(modifyListener);
            }
        }
        Composite outerContainer = new Composite(parent, 0);
        GridLayout outerLayout = new GridLayout();
        outerLayout.numColumns = 1;
        outerLayout.marginHeight = 0;
        outerLayout.marginWidth = 0;
        outerContainer.setLayout((Layout)outerLayout);
        outerContainer.setLayoutData((Object)new GridData(768));
        if (this.projectProperties != null && this.projectProperties.getMessage() != null) {
            this.addBugtrackingArea(outerContainer);
        }
        this.commitCommentArea.createArea(outerContainer);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested" && BranchTagWizardCommentPage.this.canFinish()) {
                    IClosableWizard wizard = (IClosableWizard)BranchTagWizardCommentPage.this.getWizard();
                    wizard.finishAndClose();
                }
            }
        });
        if (this.resource != null) {
            this.switchAfterBranchTagCheckBox = new Button(outerContainer, 32);
            this.switchAfterBranchTagCheckBox.setText(Policy.bind("BranchTagDialog.switchAfterTagBranch"));
        }
        this.setPageComplete(this.canFinish());
        if (this.issueText != null) {
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    ((Text)e.getSource()).selectAll();
                }

                public void focusLost(FocusEvent e) {
                    ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
                }
            };
            this.issueText.addFocusListener(focusListener);
        }
        this.setControl((Control)outerContainer);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.visited = true;
        }
        this.setPageComplete(this.canFinish());
    }

    private void addBugtrackingArea(Composite composite) {
        Composite bugtrackingComposite = new Composite(composite, 0);
        GridLayout bugtrackingLayout = new GridLayout();
        bugtrackingLayout.numColumns = 2;
        bugtrackingComposite.setLayout((Layout)bugtrackingLayout);
        Label label = new Label(bugtrackingComposite, 0);
        label.setText(this.projectProperties.getLabel());
        this.issueText = new Text(bugtrackingComposite, 2048);
        GridData data = new GridData();
        data.widthHint = 150;
        this.issueText.setLayoutData((Object)data);
    }

    private boolean canFinish() {
        if (!this.visited) {
            return false;
        }
        return this.commentProperties == null || this.commentProperties.getMinimumLogMessageSize() == 0 || this.commitCommentArea.getCommentLength() >= this.commentProperties.getMinimumLogMessageSize();
    }

    public ProjectProperties getProjectProperties() {
        return this.projectProperties;
    }

    public String getIssue() {
        if (this.issueText == null) {
            return null;
        }
        return this.issueText.getText().trim();
    }

    public String getComment() {
        if (this.projectProperties != null && this.getIssue() != null && this.getIssue().length() > 0) {
            if (this.projectProperties.isAppend()) {
                return String.valueOf(this.commitCommentArea.getComment()) + "\n" + this.projectProperties.getResolvedMessage(this.getIssue()) + "\n";
            }
            return String.valueOf(this.projectProperties.getResolvedMessage(this.getIssue())) + "\n" + this.commitCommentArea;
        }
        return this.commitCommentArea.getComment();
    }
}

