/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.UpdateResourcesCommand;
import org.tigris.subversion.subclipse.core.sync.SVNStatusSyncInfo;
import org.tigris.subversion.subclipse.core.sync.SVNWorkspaceSubscriber;
import org.tigris.subversion.subclipse.core.util.Assert;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class UpdateSynchronizeOperation
extends SVNSynchronizeOperation {
    private IResource[] resources;
    private boolean confirm;
    private boolean confirmNeeded;
    private int statusCount;
    private List errors;

    public UpdateSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IResource[] resources) {
        super(configuration, elements);
        this.resources = resources;
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.confirmNeeded) {
            final SyncInfoSet syncSet = this.getSyncInfoSet();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    UpdateSynchronizeOperation.this.confirm = MessageDialog.openConfirm((Shell)UpdateSynchronizeOperation.this.getShell(), (String)Policy.bind("SyncAction.updateAll"), (String)Policy.bind("SyncAction.updateConfirm", Integer.toString(syncSet.getSyncInfos().length)));
                }
            });
            if (!this.confirm) {
                return;
            }
        }
        this.errors = new ArrayList();
        this.statusCount = 0;
        super.run(monitor);
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IResource[] resourceArray = this.extractResources(this.resources, set);
        Map items = this.groupByRepository(resourceArray, set);
        Set keys = items.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            ISVNRepositoryLocation repos = (ISVNRepositoryLocation)iterator.next();
            List resourceList = (List)items.get(repos);
            resourceArray = new IResource[resourceList.size()];
            resourceList.toArray(resourceArray);
            SVNRevision revision = this.getRevisionForUpdate(resourceArray, set);
            this.doUpdate(provider, monitor, this.trimResources(resourceArray), revision);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doUpdate(SVNTeamProvider provider, IProgressMonitor monitor, IResource[] resourceArray, SVNRevision revision) {
        try {
            try {
                SVNWorkspaceSubscriber.getInstance().updateRemote(resourceArray);
                UpdateResourcesCommand command = new UpdateResourcesCommand(provider.getSVNWorkspaceRoot(), resourceArray, revision);
                command.run(Policy.subMonitorFor(monitor, 100));
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
            }
            catch (TeamException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        monitor.done();
    }

    private Map groupByRepository(IResource[] resourceArray, SyncInfoSet set) {
        HashMap<ISVNRepositoryLocation, ArrayList<IResource>> resourceMap = new HashMap<ISVNRepositoryLocation, ArrayList<IResource>>();
        SyncInfo[] syncInfos = set.getSyncInfos();
        int i = 0;
        while (i < syncInfos.length) {
            SVNStatusSyncInfo syncInfo = (SVNStatusSyncInfo)syncInfos[i];
            IResource local = syncInfo.getLocal();
            int j = 0;
            while (j < resourceArray.length) {
                if (resourceArray[j].equals((Object)local)) {
                    IResourceVariant remote = syncInfo.getRemote();
                    if (remote == null || !(remote instanceof ISVNRemoteResource) || syncInfo.getRemoteResourceStatus() == null) break;
                    ISVNRepositoryLocation repos = syncInfo.getRemoteResourceStatus().getRepository();
                    ArrayList<IResource> resList = (ArrayList<IResource>)resourceMap.get(repos);
                    if (resList == null) {
                        resList = new ArrayList<IResource>(resourceArray.length);
                    }
                    resList.add(resourceArray[j]);
                    resourceMap.put(repos, resList);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return resourceMap;
    }

    private SVNRevision getRevisionForUpdate(IResource[] resources, SyncInfoSet set) {
        SVNRevision revision = null;
        SyncInfo[] syncInfos = set.getSyncInfos();
        boolean useHEAD = false;
        int i = 0;
        block0: while (i < syncInfos.length) {
            SVNStatusSyncInfo syncInfo = (SVNStatusSyncInfo)syncInfos[i];
            int j = 0;
            while (j < resources.length) {
                if (resources[j].equals((Object)syncInfo.getLocal())) {
                    IResourceVariant remote = syncInfo.getRemote();
                    if (remote == null || !(remote instanceof ISVNRemoteResource)) break;
                    if (syncInfo.getRemoteResourceStatus() != null && syncInfo.getRemoteResourceStatus().getTextStatus() == SVNStatusKind.DELETED) {
                        useHEAD = true;
                        break block0;
                    }
                    SVNRevision.Number rev = ((ISVNRemoteResource)remote).getLastChangedRevision();
                    if (!(rev instanceof SVNRevision.Number)) break;
                    long nbr = rev.getNumber();
                    if (revision == null) {
                        revision = rev;
                        break;
                    }
                    long revisionNumber = ((SVNRevision.Number)revision).getNumber();
                    if (nbr <= revisionNumber) break;
                    revision = rev;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (revision == null || useHEAD) {
            revision = SVNRevision.HEAD;
        }
        return revision;
    }

    private IResource[] trimResources(IResource[] resourceArray) {
        ArrayList<IResource> folders = new ArrayList<IResource>();
        int i = 0;
        while (i < resourceArray.length) {
            if (resourceArray[i].getType() == 2 || resourceArray[i].getType() == 4) {
                folders.add(resourceArray[i]);
            }
            ++i;
        }
        ArrayList<IResource> trimmedList = new ArrayList<IResource>();
        int i2 = 0;
        while (i2 < resourceArray.length) {
            if (!this.parentIncluded(resourceArray[i2], folders)) {
                trimmedList.add(resourceArray[i2]);
            }
            ++i2;
        }
        IResource[] trimmedArray = new IResource[trimmedList.size()];
        trimmedList.toArray(trimmedArray);
        return trimmedArray;
    }

    private boolean parentIncluded(IResource resource, List folders) {
        IContainer parent = resource.getParent();
        if (parent == null) {
            return false;
        }
        if (folders.contains(parent)) {
            return true;
        }
        return this.parentIncluded((IResource)parent, folders);
    }

    public void setConfirmNeeded(boolean confirmNeeded) {
        this.confirmNeeded = confirmNeeded;
    }

    private void collectStatus(IStatus status) {
        if (this.isLastError(status)) {
            return;
        }
        ++this.statusCount;
        if (!status.isOK()) {
            this.addError(status);
        }
    }

    private boolean isLastError(IStatus status) {
        return this.errors.size() > 0 && this.getLastError() == status;
    }

    private void addError(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
    }

    private IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = (IStatus)this.errors.get(this.errors.size() - 1);
        return status;
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected String getJobName() {
        return Policy.bind("UpdateOperation.taskName");
    }
}

