/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.File2Resource;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.ConflictsCompareInput;
import org.tigris.subversion.subclipse.ui.subscriber.SVNSynchronizeOperation;
import org.tigris.subversion.svnclientadapter.utils.Command;

public class EditConflictsSynchronizeOperation
extends SVNSynchronizeOperation {
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;

    public EditConflictsSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        return true;
    }

    protected void run(SVNTeamProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IResource[] resources = set.getResources();
        if (resources[0] instanceof IFile) {
            final IFile resource = (IFile)resources[0];
            this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                    try {
                        IFile conflictNewFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictNew());
                        IFile conflictOldFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictOld());
                        IFile conflictWorkingFile = (IFile)File2Resource.getResource((File)svnResource.getStatus().getConflictWorking());
                        IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
                        if (preferenceStore.getBoolean("pref_merge_use_external")) {
                            EditConflictsSynchronizeOperation.this.editConflictsExternal(resource, conflictOldFile, conflictWorkingFile, conflictNewFile);
                        } else {
                            EditConflictsSynchronizeOperation.this.editConflictsInternal(resource, conflictOldFile, conflictWorkingFile, conflictNewFile);
                        }
                    }
                    catch (SVNException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, false, 2);
        }
    }

    private void editConflictsInternal(IFile resource, IFile conflictOldFile, IFile conflictWorkingFile, IFile conflictNewFile) throws InvocationTargetException, InterruptedException {
        CompareConfiguration cc = new CompareConfiguration();
        final ConflictsCompareInput fInput = new ConflictsCompareInput(cc);
        fInput.setResources(conflictOldFile, conflictWorkingFile, conflictNewFile, resource);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                CompareUI.openCompareEditorOnPage((CompareEditorInput)fInput, (IWorkbenchPage)EditConflictsSynchronizeOperation.this.getPart().getSite().getPage());
            }
        });
    }

    private void editConflictsExternal(final IFile resource, IFile conflictOldFile, IFile conflictWorkingFile, IFile conflictNewFile) throws CoreException, InvocationTargetException, InterruptedException {
        IPreferenceStore preferenceStore = SVNUIPlugin.getPlugin().getPreferenceStore();
        String mergeProgramLocation = preferenceStore.getString("pref_merge_program_location");
        String mergeProgramParameters = preferenceStore.getString("pref_merge_program_parameters");
        if (mergeProgramLocation.equals("")) {
            throw new SVNException(Policy.bind("EditConflictsAction.noMergeProgramConfigured"));
        }
        File mergeProgramFile = new File(mergeProgramLocation);
        if (!mergeProgramFile.exists()) {
            throw new SVNException(Policy.bind("EditConflictsAction.mergeProgramDoesNotExist"));
        }
        final Command command = new Command(mergeProgramLocation);
        String[] parameters = mergeProgramParameters.split(" ");
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = this.replaceParameter(parameters[i], "${theirs}", conflictNewFile.getLocation().toFile().getAbsolutePath());
            parameters[i] = this.replaceParameter(parameters[i], "${yours}", conflictWorkingFile.getLocation().toFile().getAbsolutePath());
            parameters[i] = this.replaceParameter(parameters[i], "${base}", conflictOldFile.getLocation().toFile().getAbsolutePath());
            parameters[i] = this.replaceParameter(parameters[i], "${merged}", resource.getLocation().toFile().getAbsolutePath());
            ++i;
        }
        command.setParameters(parameters);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    command.exec();
                    command.waitFor();
                    resource.refreshLocal(0, null);
                }
                catch (Exception e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                }
            }
        });
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SVNUIPlugin.getPlugin().getRepositoryManager().run(runnable, monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    private String replaceParameter(String input, String pattern, String value) {
        StringBuffer result = new StringBuffer();
        int startIdx = 0;
        int idxOld = 0;
        while ((idxOld = input.indexOf(pattern, startIdx)) >= 0) {
            result.append(input.substring(startIdx, idxOld));
            result.append(value);
            startIdx = idxOld + pattern.length();
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }
}

