/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.operations;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.BranchTagCommand;
import org.tigris.subversion.subclipse.core.commands.GetRemoteResourceCommand;
import org.tigris.subversion.subclipse.core.commands.SwitchToUrlCommand;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.operations.RepositoryProviderOperation;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class BranchTagOperation
extends RepositoryProviderOperation {
    private SVNUrl[] sourceUrls;
    private SVNUrl destinationUrl;
    private SVNRevision revision;
    private boolean createOnServer;
    private boolean makeParents;
    private String message;
    private Alias newAlias;
    private boolean switchAfterTagBranch;
    private boolean branchCreated = false;
    private boolean multipleTransactions = true;

    public BranchTagOperation(IWorkbenchPart part, IResource[] resources, SVNUrl[] sourceUrls, SVNUrl destinationUrl, boolean createOnServer, SVNRevision revision, String message) {
        super(part, resources);
        this.sourceUrls = sourceUrls;
        this.destinationUrl = destinationUrl;
        this.createOnServer = createOnServer;
        this.revision = revision;
        this.message = message;
    }

    protected String getTaskName() {
        return Policy.bind("BranchTagOperation.taskName");
    }

    protected String getTaskName(SVNTeamProvider provider) {
        return Policy.bind("BranchTagOperation.0", provider.getProject().getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(SVNTeamProvider provider, IResource[] resources, IProgressMonitor monitor) throws SVNException, InterruptedException {
        if (this.branchCreated) {
            return;
        }
        this.branchCreated = true;
        monitor.beginTask(null, 100);
        try {
            try {
                BranchTagCommand command = new BranchTagCommand(provider.getSVNWorkspaceRoot(), this.getResources(), this.sourceUrls, this.destinationUrl, this.message, this.createOnServer, this.revision);
                command.setMakeParents(this.makeParents);
                command.setMultipleTransactions(this.multipleTransactions);
                command.run(Policy.subMonitorFor(monitor, 1000));
                if (this.newAlias != null) {
                    this.updateBranchTagProperty(resources[0]);
                }
                if (this.switchAfterTagBranch) {
                    int i = 0;
                    while (i < this.sourceUrls.length) {
                        SVNUrl switchDestinationUrl = command.getDestinationUrl(this.sourceUrls[i].toString());
                        GetRemoteResourceCommand getRemoteResourceCommand = new GetRemoteResourceCommand(provider.getSVNWorkspaceRoot().getRepository(), switchDestinationUrl, SVNRevision.HEAD);
                        try {
                            getRemoteResourceCommand.run(null);
                        }
                        catch (SVNException e) {
                            if (e.getStatus().getCode() != -6) throw e;
                            switchDestinationUrl = this.destinationUrl;
                        }
                        resources = this.getResources();
                        SwitchToUrlCommand switchToUrlCommand = new SwitchToUrlCommand(provider.getSVNWorkspaceRoot(), resources[i], switchDestinationUrl, SVNRevision.HEAD);
                        switchToUrlCommand.run(Policy.subMonitorFor(monitor, 100));
                        ++i;
                    }
                }
            }
            catch (SVNException e) {
                this.collectStatus(e.getStatus());
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        monitor.done();
    }

    protected ISchedulingRule getSchedulingRule(SVNTeamProvider provider) {
        IResource[] resources = this.getResources();
        if (resources == null) {
            return super.getSchedulingRule(provider);
        }
        IResourceRuleFactory ruleFactory = provider.getRuleFactory();
        HashSet<ISchedulingRule> rules = new HashSet<ISchedulingRule>();
        int i = 0;
        while (i < resources.length) {
            rules.add(ruleFactory.modifyRule((IResource)resources[i].getProject()));
            ++i;
        }
        return MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private void updateBranchTagProperty(IResource resource) {
        AliasManager aliasManager = new AliasManager(resource, false);
        Alias[] branchAliases = aliasManager.getBranches();
        Alias[] tagAliases = aliasManager.getTags();
        StringBuffer propertyValue = new StringBuffer();
        int i = 0;
        while (i < branchAliases.length) {
            if (branchAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias branch = branchAliases[i];
                propertyValue.append(String.valueOf(branch.getRevision()) + "," + branch.getName());
                if (branch.getRelativePath() != null) {
                    propertyValue.append("," + branch.getRelativePath());
                }
                if (branch.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        i = 0;
        while (i < tagAliases.length) {
            if (tagAliases[i].getRevision() > 0) {
                if (propertyValue.length() > 0) {
                    propertyValue.append("\n");
                }
                Alias tag = tagAliases[i];
                propertyValue.append(String.valueOf(tag.getRevision()) + "," + tag.getName());
                if (tag.getRelativePath() != null) {
                    propertyValue.append("," + tag.getRelativePath());
                }
                if (tag.isBranch()) {
                    propertyValue.append(",branch");
                } else {
                    propertyValue.append(",tag");
                }
            }
            ++i;
        }
        if (propertyValue.length() > 0) {
            propertyValue.append("\n");
        }
        propertyValue.append(String.valueOf(this.newAlias.getRevision()) + "," + this.newAlias.getName() + "," + this.newAlias.getRelativePath());
        if (this.newAlias.isBranch()) {
            propertyValue.append(",branch");
        } else {
            propertyValue.append(",tag");
        }
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
        try {
            svnResource.setSvnProperty("subclipse:tags", propertyValue.toString(), false);
        }
        catch (SVNException sVNException) {}
    }

    public void setNewAlias(Alias newAlias) {
        this.newAlias = newAlias;
    }

    public void switchAfterTagBranchOperation(boolean switchAfterTagBranchOperation) {
        this.switchAfterTagBranch = switchAfterTagBranchOperation;
    }

    public void setMakeParents(boolean makeParents) {
        this.makeParents = makeParents;
    }

    public void setMultipleTransactions(boolean multipleTransactions) {
        this.multipleTransactions = multipleTransactions;
    }
}

