/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.comments.CommitCommentArea;
import org.tigris.subversion.subclipse.ui.operations.ImportOperation;

public class ImportFolderDialog
extends TrayDialog {
    private ISVNRemoteFolder remoteFolder;
    private IWorkbenchPart targetPart;
    private Text directoryText;
    private Button recurseButton;
    private CommitCommentArea commitCommentArea;
    private Button okButton;

    public ImportFolderDialog(Shell parentShell, ISVNRemoteFolder remoteFolder, IWorkbenchPart targetPart) {
        super(parentShell);
        this.setShellStyle(1264);
        this.remoteFolder = remoteFolder;
        this.targetPart = targetPart;
        this.commitCommentArea = new CommitCommentArea((Dialog)this, null, Policy.bind("ImportFolderDialog.comment"));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("ImportFolderDialog.title"));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite repositoryComposite = new Composite(composite, 0);
        repositoryComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        repositoryComposite.setLayout((Layout)new GridLayout());
        Group repositoryGroup = new Group(repositoryComposite, 0);
        repositoryGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        repositoryGroup.setText(Policy.bind("ExportRemoteFolderDialog.repository"));
        repositoryGroup.setLayout((Layout)new GridLayout(2, false));
        Label urlLabel = new Label((Composite)repositoryGroup, 0);
        urlLabel.setText(Policy.bind("ExportRemoteFolderDialog.url"));
        GridData data = new GridData(16384, 0x1000000, true, false, 2, 1);
        urlLabel.setLayoutData((Object)data);
        Text urlText = new Text((Composite)repositoryGroup, 2048);
        data = new GridData(4, 0x1000000, true, false, 2, 1);
        data.widthHint = 600;
        urlText.setLayoutData((Object)data);
        urlText.setEditable(false);
        urlText.setText(this.remoteFolder.getUrl().toString());
        Label directoryLabel = new Label((Composite)repositoryGroup, 0);
        directoryLabel.setText(Policy.bind("ImportFolderDialog.directory"));
        data = new GridData(16384, 0x1000000, true, false, 2, 1);
        directoryLabel.setLayoutData((Object)data);
        this.directoryText = new Text((Composite)repositoryGroup, 2048);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 600;
        this.directoryText.setLayoutData((Object)data);
        this.directoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportFolderDialog.this.setOkButtonStatus();
            }
        });
        Button directoryBrowseButton = new Button((Composite)repositoryGroup, 8);
        directoryBrowseButton.setText(Policy.bind("ExportRemoteFolderDialog.browse"));
        directoryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportFolderDialog.this.getShell(), 8192);
                dialog.setText(Policy.bind("ImportFolderDialog.title"));
                String directory = dialog.open();
                if (directory != null) {
                    ImportFolderDialog.this.directoryText.setText(directory);
                    ImportFolderDialog.this.setOkButtonStatus();
                }
            }
        });
        this.recurseButton = new Button((Composite)repositoryGroup, 32);
        this.recurseButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.recurseButton.setText(Policy.bind("ImportFolderDialog.recurse"));
        this.recurseButton.setSelection(true);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.directoryText.addFocusListener((FocusListener)focusListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.import_folder_dialog_context");
        this.commitCommentArea.createArea(composite);
        this.directoryText.setFocus();
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.okButton = button;
            this.okButton.setEnabled(false);
        }
        return button;
    }

    private void setOkButtonStatus() {
        this.okButton.setEnabled(this.directoryText.getText().trim().length() > 0);
    }

    protected void okPressed() {
        boolean success = true;
        try {
            File directory = new File(this.directoryText.getText().trim());
            new ImportOperation(this.targetPart, this.remoteFolder, directory, this.commitCommentArea.getComment(), this.recurseButton.getSelection()).run();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ImportFolderDialog.title"), (String)e.getMessage());
            success = false;
        }
        if (!success) {
            return;
        }
        super.okPressed();
    }
}

