/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.commands.GetLogsCommand;
import org.tigris.subversion.subclipse.core.history.AliasManager;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntry;
import org.tigris.subversion.subclipse.core.history.LogEntryChangePath;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.history.ChangePathsTreeViewer;
import org.tigris.subversion.subclipse.ui.history.HistoryFolder;
import org.tigris.subversion.subclipse.ui.history.HistoryTableProvider;
import org.tigris.subversion.subclipse.ui.settings.ProjectProperties;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class HistoryDialog
extends TrayDialog {
    private IResource resource;
    private ISVNRemoteResource remoteResource;
    private SashForm sashForm;
    private HistoryTableProvider historyTableProvider;
    private ChangePathsTreeViewer changePathsViewer;
    private TableViewer tableHistoryViewer;
    private TextViewer textViewer;
    private Button stopOnCopyButton;
    private Button getAllButton;
    private Button getNextButton;
    private AliasManager tagManager;
    private ILogEntry[] entries;
    private IDialogSettings settings;
    private ILogEntry[] selectedEntries;
    private IPreferenceStore store;
    private SVNRevision revisionStart = SVNRevision.HEAD;
    private boolean getNextEnabled = true;
    private boolean includeTags = true;
    private boolean includeBugs = false;
    private static final int WIDTH_HINT = 500;
    private static final int LOG_HEIGHT_HINT = 200;
    private static final int COMMENT_HEIGHT_HINT = 100;

    public HistoryDialog(Shell parentShell, IResource resource) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.resource = resource;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        this.store = SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    public HistoryDialog(Shell parentShell, ISVNRemoteResource remoteResource) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.remoteResource = remoteResource;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        this.store = SVNUIPlugin.getPlugin().getPreferenceStore();
    }

    protected Control createDialogArea(Composite parent) {
        this.getLogEntries();
        if (this.resource == null) {
            this.getShell().setText(String.valueOf(Policy.bind("HistoryDialog.title")) + " - " + this.remoteResource.getName());
            this.setIncludeBugsAndTags(this.remoteResource);
        } else {
            this.getShell().setText(String.valueOf(Policy.bind("HistoryDialog.title")) + " - " + this.resource.getName());
            this.setIncludeBugsAndTags(this.resource);
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.sashForm = new SashForm(composite, 512);
        GridLayout sashLayout = new GridLayout();
        sashLayout.verticalSpacing = 0;
        sashLayout.marginHeight = 0;
        this.sashForm.setLayout((Layout)sashLayout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        Composite historyGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout historyLayout = new GridLayout();
        historyLayout.verticalSpacing = 0;
        historyLayout.marginHeight = 0;
        historyLayout.marginTop = 5;
        historyGroup.setLayout((Layout)historyLayout);
        historyGroup.setLayoutData((Object)new GridData(1808));
        this.historyTableProvider = new HistoryTableProvider(68354, "HistoryDialog");
        this.historyTableProvider.setIncludeBugs(this.includeBugs);
        this.historyTableProvider.setIncludeMergeRevisions(false);
        this.historyTableProvider.setIncludeTags(this.includeTags);
        this.historyTableProvider.setRemoteResource(this.remoteResource);
        this.tableHistoryViewer = this.historyTableProvider.createTable(historyGroup);
        data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 200;
        this.tableHistoryViewer.getTable().setLayoutData((Object)data);
        this.tableHistoryViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return HistoryDialog.this.entries;
            }
        });
        this.tableHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    HistoryDialog.this.textViewer.setDocument((IDocument)new Document(""));
                    HistoryDialog.this.changePathsViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    HistoryDialog.this.textViewer.setDocument((IDocument)new Document(""));
                    HistoryDialog.this.changePathsViewer.setInput(null);
                    return;
                }
                LogEntry entry = (LogEntry)ss.getFirstElement();
                HistoryDialog.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                HistoryDialog.this.changePathsViewer.setCurrentLogEntry((ILogEntry)entry);
                HistoryDialog.this.changePathsViewer.setInput(entry);
            }
        });
        this.tableHistoryViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HistoryDialog.this.okPressed();
            }
        });
        this.tableHistoryViewer.setInput((Object)this.remoteResource);
        this.tableHistoryViewer.resetFilters();
        Composite commentGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout commentLayout = new GridLayout();
        commentLayout.verticalSpacing = 0;
        commentLayout.marginHeight = 0;
        commentGroup.setLayout((Layout)commentLayout);
        commentGroup.setLayoutData((Object)new GridData(1808));
        this.textViewer = new TextViewer(commentGroup, 2634);
        data = new GridData(1808);
        data.heightHint = 100;
        data.widthHint = 500;
        this.textViewer.getControl().setLayoutData((Object)data);
        Composite pathGroup = new Composite((Composite)this.sashForm, 0);
        GridLayout pathLayout = new GridLayout();
        pathLayout.verticalSpacing = 0;
        pathLayout.marginHeight = 0;
        pathGroup.setLayout((Layout)pathLayout);
        pathGroup.setLayoutData((Object)new GridData(1808));
        ChangePathsTreeContentProvider contentProvider = new ChangePathsTreeContentProvider();
        this.changePathsViewer = new ChangePathsTreeViewer(pathGroup, (IContentProvider)contentProvider);
        this.stopOnCopyButton = new Button(composite, 32);
        data = new GridData();
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        this.stopOnCopyButton.setLayoutData((Object)data);
        this.stopOnCopyButton.setText(Policy.bind("HistoryView.stopOnCopy"));
        this.stopOnCopyButton.setSelection(this.store.getBoolean("pref_stop_on_copy"));
        this.stopOnCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryDialog.this.store.setValue("pref_stop_on_copy", HistoryDialog.this.stopOnCopyButton.getSelection());
                HistoryDialog.this.revisionStart = SVNRevision.HEAD;
                HistoryDialog.this.getLogEntries();
                HistoryDialog.this.tableHistoryViewer.refresh();
            }
        });
        try {
            int[] weights = new int[]{this.settings.getInt("HistoryDialog.weights.0"), this.settings.getInt("HistoryDialog.weights.1"), this.settings.getInt("HistoryDialog.weights.2")};
            this.sashForm.setWeights(weights);
        }
        catch (Exception exception) {}
        this.historyTableProvider.setSortColumn(this.tableHistoryViewer, 0);
        this.historyTableProvider.setSortColumn(this.tableHistoryViewer, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.history_dialog_context");
        return composite;
    }

    private void setIncludeBugsAndTags(IResource res) {
        try {
            ProjectProperties projectProperties = ProjectProperties.getProjectProperties(this.resource);
            this.includeBugs = projectProperties != null;
            this.includeTags = this.tagsPropertySet(res);
        }
        catch (SVNException e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e);
        }
    }

    private boolean tagsPropertySet(IResource res) {
        if (res == null) {
            return false;
        }
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)res);
        try {
            if (svnResource.isManaged()) {
                ISVNProperty property = null;
                property = svnResource.getSvnProperty("subclipse:tags");
                if (property != null && property.getValue() != null) {
                    return true;
                }
            }
        }
        catch (SVNException sVNException) {}
        return false;
    }

    private boolean tagsPropertySet(ISVNRemoteResource res) {
        try {
            ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClient();
            ISVNProperty property = null;
            SVNProviderPlugin.disableConsoleLogging();
            property = client.propertyGet(res.getUrl(), "subclipse:tags");
            SVNProviderPlugin.enableConsoleLogging();
            if (property != null && property.getValue() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            SVNProviderPlugin.enableConsoleLogging();
        }
        return false;
    }

    private void setIncludeBugsAndTags(ISVNRemoteResource res) {
        ProjectProperties projectProperties = null;
        try {
            projectProperties = ProjectProperties.getProjectProperties(res);
        }
        catch (SVNException e) {
            SVNUIPlugin.openError(Display.getCurrent().getActiveShell(), null, null, e);
        }
        this.includeBugs = projectProperties != null;
        this.includeTags = this.tagsPropertySet(res);
    }

    private void getLogEntries() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ISVNLocalResource localResource;
                    if (HistoryDialog.this.remoteResource == null && (localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)HistoryDialog.this.resource)) != null && !localResource.getStatus().isAdded() && localResource.getStatus().isManaged()) {
                        HistoryDialog.this.remoteResource = localResource.getBaseResource();
                    }
                    if (HistoryDialog.this.remoteResource != null) {
                        if (SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote")) {
                            HistoryDialog.this.tagManager = new AliasManager(HistoryDialog.this.remoteResource.getUrl());
                        }
                        SVNRevision pegRevision = HistoryDialog.this.remoteResource.getRevision();
                        SVNRevision.Number revisionEnd = new SVNRevision.Number(0L);
                        boolean stopOnCopy = HistoryDialog.this.store.getBoolean("pref_stop_on_copy");
                        int entriesToFetch = HistoryDialog.this.store.getInt("pref_log_entries_to_fetch");
                        long limit = entriesToFetch;
                        HistoryDialog.this.entries = HistoryDialog.this.getLogEntries(HistoryDialog.this.remoteResource, pegRevision, HistoryDialog.this.revisionStart, (SVNRevision)revisionEnd, stopOnCopy, limit + 1L, HistoryDialog.this.tagManager);
                        long entriesLength = HistoryDialog.this.entries.length;
                        if (entriesLength > limit) {
                            ILogEntry[] fetchedEntries = new ILogEntry[HistoryDialog.this.entries.length - 1];
                            int i = 0;
                            while (i < HistoryDialog.this.entries.length - 1) {
                                fetchedEntries[i] = HistoryDialog.this.entries[i];
                                ++i;
                            }
                            HistoryDialog.this.entries = fetchedEntries;
                        } else {
                            HistoryDialog.this.getNextEnabled = false;
                        }
                        if (HistoryDialog.this.entries.length > 0) {
                            ILogEntry lastEntry = HistoryDialog.this.entries[HistoryDialog.this.entries.length - 1];
                            long lastEntryNumber = lastEntry.getRevision().getNumber();
                            HistoryDialog.this.revisionStart = (SVNRevision)new SVNRevision.Number(lastEntryNumber - 1L);
                        }
                    }
                }
                catch (TeamException e) {
                    SVNUIPlugin.openError(Display.getCurrent().getActiveShell(), null, null, e);
                }
            }
        });
    }

    private void getNextLogEntries() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ISVNLocalResource localResource;
                    if (HistoryDialog.this.remoteResource == null && (localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)HistoryDialog.this.resource)) != null && !localResource.getStatus().isAdded() && localResource.getStatus().isManaged()) {
                        HistoryDialog.this.remoteResource = localResource.getBaseResource();
                    }
                    if (HistoryDialog.this.remoteResource != null) {
                        int i;
                        SVNRevision pegRevision = HistoryDialog.this.remoteResource.getRevision();
                        SVNRevision.Number revisionEnd = new SVNRevision.Number(0L);
                        boolean stopOnCopy = HistoryDialog.this.store.getBoolean("pref_stop_on_copy");
                        int entriesToFetch = HistoryDialog.this.store.getInt("pref_log_entries_to_fetch");
                        long limit = entriesToFetch;
                        ILogEntry[] nextEntries = HistoryDialog.this.getLogEntries(HistoryDialog.this.remoteResource, pegRevision, HistoryDialog.this.revisionStart, (SVNRevision)revisionEnd, stopOnCopy, limit + 1L, HistoryDialog.this.tagManager);
                        long entriesLength = nextEntries.length;
                        if (entriesLength > limit) {
                            ILogEntry[] fetchedEntries = new ILogEntry[nextEntries.length - 1];
                            i = 0;
                            while (i < nextEntries.length - 1) {
                                fetchedEntries[i] = nextEntries[i];
                                ++i;
                            }
                            HistoryDialog.this.getNextButton.setEnabled(true);
                        } else {
                            HistoryDialog.this.getNextButton.setEnabled(false);
                        }
                        ArrayList<ILogEntry> entryArray = new ArrayList<ILogEntry>();
                        if (HistoryDialog.this.entries == null) {
                            HistoryDialog.this.entries = new ILogEntry[0];
                        }
                        i = 0;
                        while (i < HistoryDialog.this.entries.length) {
                            entryArray.add(HistoryDialog.this.entries[i]);
                            ++i;
                        }
                        i = 0;
                        while (i < nextEntries.length) {
                            entryArray.add(nextEntries[i]);
                            ++i;
                        }
                        HistoryDialog.this.entries = new ILogEntry[entryArray.size()];
                        entryArray.toArray(HistoryDialog.this.entries);
                        if (HistoryDialog.this.entries.length > 0) {
                            ILogEntry lastEntry = HistoryDialog.this.entries[HistoryDialog.this.entries.length - 1];
                            long lastEntryNumber = lastEntry.getRevision().getNumber();
                            HistoryDialog.this.revisionStart = (SVNRevision)new SVNRevision.Number(lastEntryNumber - 1L);
                        }
                    }
                }
                catch (TeamException e) {
                    SVNUIPlugin.openError(Display.getCurrent().getActiveShell(), null, null, e);
                }
            }
        });
        ISelection selection = this.tableHistoryViewer.getSelection();
        this.tableHistoryViewer.refresh();
        this.tableHistoryViewer.setSelection(selection);
    }

    private void getAllLogEntries() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ISVNLocalResource localResource;
                    if (HistoryDialog.this.remoteResource == null && (localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)HistoryDialog.this.resource)) != null && !localResource.getStatus().isAdded() && localResource.getStatus().isManaged()) {
                        HistoryDialog.this.remoteResource = localResource.getBaseResource();
                    }
                    if (HistoryDialog.this.remoteResource != null) {
                        if (SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_tags_in_remote")) {
                            HistoryDialog.this.tagManager = new AliasManager(HistoryDialog.this.remoteResource.getUrl());
                        }
                        SVNRevision pegRevision = HistoryDialog.this.remoteResource.getRevision();
                        SVNRevision.Number revisionEnd = new SVNRevision.Number(0L);
                        HistoryDialog.this.revisionStart = SVNRevision.HEAD;
                        boolean stopOnCopy = HistoryDialog.this.store.getBoolean("pref_stop_on_copy");
                        long limit = 0L;
                        HistoryDialog.this.entries = HistoryDialog.this.getLogEntries(HistoryDialog.this.remoteResource, pegRevision, HistoryDialog.this.revisionStart, (SVNRevision)revisionEnd, stopOnCopy, limit, HistoryDialog.this.tagManager);
                        HistoryDialog.this.getNextButton.setEnabled(false);
                    }
                }
                catch (TeamException e) {
                    SVNUIPlugin.openError(Display.getCurrent().getActiveShell(), null, null, e);
                }
            }
        });
        this.tableHistoryViewer.refresh();
    }

    protected ILogEntry[] getLogEntries(ISVNRemoteResource remoteResource, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, long limit, AliasManager tagManager) throws TeamException {
        GetLogsCommand logCmd = new GetLogsCommand(remoteResource, pegRevision, revisionStart, revisionEnd, stopOnCopy, limit, tagManager, false);
        logCmd.run(null);
        return logCmd.getLogEntries();
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        this.store.setValue("pref_stop_on_copy", this.stopOnCopyButton.getSelection());
        IStructuredSelection selection = (IStructuredSelection)this.tableHistoryViewer.getSelection();
        this.selectedEntries = new ILogEntry[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.selectedEntries[i++] = (ILogEntry)iter.next();
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.getAllButton = this.createButton(parent, 2, Policy.bind("HistoryView.getAll"), false);
        this.getAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryDialog.this.getAllLogEntries();
            }
        });
        int entriesToFetch = this.store.getInt("pref_log_entries_to_fetch");
        if (entriesToFetch > 0) {
            this.getNextButton = this.createButton(parent, 3, String.valueOf(Policy.bind("HistoryView.getNext")) + " " + entriesToFetch, false);
            this.getNextButton.setEnabled(this.getNextEnabled);
            this.getNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HistoryDialog.this.getNextLogEntries();
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("HistoryDialog.location.x");
            int y = this.settings.getInt("HistoryDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("HistoryDialog.size.x");
            int y = this.settings.getInt("HistoryDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return new Point(400, 400);
        }
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("HistoryDialog.location.x", x);
        this.settings.put("HistoryDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("HistoryDialog.size.x", x);
        this.settings.put("HistoryDialog.size.y", y);
        int[] weights = this.sashForm.getWeights();
        int i = 0;
        while (i < weights.length) {
            this.settings.put("HistoryDialog.weights." + i, weights[i]);
            ++i;
        }
    }

    public ILogEntry[] getSelectedLogEntries() {
        return this.selectedEntries;
    }

    static class ChangePathsTreeContentProvider
    implements ITreeContentProvider {
        ChangePathsTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof HistoryFolder) {
                return ((HistoryFolder)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof HistoryFolder) {
                HistoryFolder folder = (HistoryFolder)element;
                return folder.getChildren().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ILogEntry logEntry = (ILogEntry)inputElement;
            return this.getGroups(logEntry.getLogEntryChangePaths());
        }

        private Object[] getGroups(LogEntryChangePath[] changePaths) {
            HashSet<String> folderNames = new HashSet<String>();
            int i = 0;
            while (i < changePaths.length) {
                folderNames.add(this.getFolderName(changePaths[i]));
                ++i;
            }
            TreeMap<String, HistoryFolder> folders = new TreeMap<String, HistoryFolder>();
            int i2 = 0;
            while (i2 < changePaths.length) {
                HistoryFolder folder;
                LogEntryChangePath changePath = changePaths[i2];
                String path = changePath.getPath();
                if (folderNames.contains(path)) {
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(changePath);
                        folders.put(path, folder);
                    }
                } else {
                    path = this.getFolderName(changePath);
                    folder = (HistoryFolder)folders.get(path);
                    if (folder == null) {
                        folder = new HistoryFolder(path);
                        folders.put(path, folder);
                    }
                    folder.add(changePath);
                }
                ++i2;
            }
            return folders.values().toArray(new Object[folders.size()]);
        }

        private String getFolderName(LogEntryChangePath changePath) {
            String path = changePath.getPath();
            int n = path.lastIndexOf(47);
            return n > -1 ? path.substring(0, n) : path;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

