/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.internal.BufferedResourceNode;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;

public class ConflictsCompareInput
extends CompareEditorInput {
    private Object fRoot;
    private BufferedResourceNode fAncestor;
    private BufferedResourceNode fLeft;
    private BufferedResourceNode fRight;
    private IFile fAncestorResource;
    private IFile fMineResource;
    private IFile fTheirsResource;
    private IFile fDestinationResource;
    private boolean neverSaved = true;
    private boolean isSaving = false;

    public ConflictsCompareInput(CompareConfiguration config) {
        super(config);
    }

    public void setResources(IFile ancestor, IFile mine, IFile theirs, IFile destination) {
        this.fAncestorResource = ancestor;
        this.fMineResource = mine;
        this.fTheirsResource = theirs;
        this.fDestinationResource = destination;
        this.initializeCompareConfiguration();
    }

    private String getType() {
        String s = this.fDestinationResource.getFileExtension();
        if (s != null) {
            return s;
        }
        return "???";
    }

    private void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String leftLabel = "Merged - " + this.fDestinationResource.getName();
        String rightLabel = "Theirs - " + this.fTheirsResource.getName();
        String ancestorLabel = "Ancestor -" + this.fAncestorResource.getName();
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
        cc.setAncestorLabel(ancestorLabel);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object prepareInput(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        Object object;
        try {
            try {
                byte[] contents;
                pm.beginTask(Utilities.getString("ResourceCompare.taskName"), -1);
                this.fMineResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
                this.fTheirsResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
                this.fAncestorResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
                this.fDestinationResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
                this.fAncestor = new BufferedResourceNode((IResource)this.fAncestorResource){

                    public String getType() {
                        return ConflictsCompareInput.this.getType();
                    }

                    public boolean isEditable() {
                        return false;
                    }
                };
                this.fLeft = new BufferedResourceNode((IResource)this.fDestinationResource){

                    public String getType() {
                        return ConflictsCompareInput.this.getType();
                    }
                };
                InputStream mineContents = this.fMineResource.getContents();
                try {
                    contents = new byte[mineContents.available()];
                    mineContents.read(contents);
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    mineContents.close();
                    throw throwable;
                }
                {
                    Object var4_9 = null;
                }
                mineContents.close();
                this.fLeft.setContent(contents);
                this.fLeft.addContentChangeListener(new IContentChangeListener(){

                    public void contentChanged(IContentChangeNotifier source) {
                        if (!ConflictsCompareInput.this.isSaving) {
                            try {
                                ConflictsCompareInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException e) {
                                SVNUIPlugin.log(4, e.getMessage(), e);
                            }
                        }
                    }
                });
                this.fRight = new BufferedResourceNode((IResource)this.fTheirsResource){

                    public String getType() {
                        return ConflictsCompareInput.this.getType();
                    }

                    public boolean isEditable() {
                        return false;
                    }
                };
                String title = "Conflicts on " + this.fDestinationResource.getName();
                this.setTitle(title);
                Differencer d = new Differencer(){

                    protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                        return new MyDiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                    }
                };
                object = this.fRoot = d.findDifferences(true, pm, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
                Object var6_11 = null;
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveChanges(IProgressMonitor pm) throws CoreException {
        try {
            this.isSaving = true;
            super.saveChanges(pm);
            this.fLeft.commit(pm);
            this.neverSaved = false;
            ((MyDiffNode)((Object)this.fRoot)).fireChange();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.isSaving = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.isSaving = false;
            return;
        }
    }

    public boolean isSaveNeeded() {
        if (this.neverSaved) {
            return true;
        }
        return super.isSaveNeeded();
    }

    public static class MyDiffNode
    extends DiffNode {
        public MyDiffNode(IDiffContainer parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, kind, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
        }
    }
}

