/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.ResourceEditionNode;
import org.tigris.subversion.subclipse.ui.compare.RevisionAwareDifferencer;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;
import org.tigris.subversion.subclipse.ui.internal.Utils;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNLocalCompareInput
extends CompareEditorInput
implements ISaveableWorkbenchPart {
    private final SVNRevision remoteRevision;
    private ISVNLocalResource resource;
    private Shell shell;
    private final ISVNRemoteResource remoteResource;
    private boolean readOnly;

    public SVNLocalCompareInput(ISVNLocalResource resource, SVNRevision revision, boolean readOnly) throws SVNException {
        super(new CompareConfiguration());
        this.remoteRevision = revision;
        this.readOnly = readOnly;
        this.resource = resource;
        this.remoteResource = resource.getRemoteResource(revision);
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, SVNRevision revision) throws SVNException {
        this(resource, revision, false);
    }

    public SVNLocalCompareInput(ISVNLocalResource resource, ISVNRemoteResource remoteResource) throws SVNException {
        super(new CompareConfiguration());
        this.resource = resource;
        this.remoteResource = remoteResource;
        this.remoteRevision = remoteResource.getRevision();
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String resourceName = this.resource.getName();
        this.setTitle(Policy.bind("SVNCompareRevisionsInput.compareResourceAndVersions", new Object[]{resourceName}));
        cc.setLeftEditable(!this.readOnly);
        cc.setRightEditable(false);
        String leftLabel = Policy.bind("SVNCompareRevisionsInput.workspace", new Object[]{resourceName});
        cc.setLeftLabel(leftLabel);
        String rightLabel = Policy.bind("SVNCompareRevisionsInput.repository", new Object[]{resourceName});
        cc.setRightLabel(rightLabel);
    }

    protected Object prepareInput(IProgressMonitor monitor) {
        this.initLabels();
        SVNLocalResourceNode left = new SVNLocalResourceNode(this.resource);
        ResourceEditionNode right = new ResourceEditionNode(this.remoteResource);
        if (left.getType() == "FOLDER") {
            right.setLocalResource(left);
        }
        String localCharset = Utilities.getCharset(this.resource.getIResource());
        try {
            right.setCharset(localCharset);
        }
        catch (CoreException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
        if (SVNRevision.BASE.equals((Object)this.remoteRevision)) {
            return new StatusAwareDifferencer().findDifferences(false, monitor, null, null, (Object)left, right);
        }
        return new RevisionAwareDifferencer().findDifferences(false, monitor, null, null, (Object)left, right);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveChanges(monitor);
        }
        catch (CoreException e) {
            Utils.handle(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createContents(parent);
    }

    public void dispose() {
    }

    public IWorkbenchPartSite getSite() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    class StatusAwareDifferencer
    extends Differencer {
        StatusAwareDifferencer() {
        }

        protected boolean contentsEqual(Object left, Object right) {
            ISVNLocalResource local;
            block5: {
                local = null;
                if (left instanceof SVNLocalResourceNode) {
                    local = ((SVNLocalResourceNode)((Object)left)).getLocalResource();
                }
                if (local == null || right == null) {
                    return false;
                }
                try {
                    if (local.isManaged()) break block5;
                    return false;
                }
                catch (SVNException sVNException) {
                    return super.contentsEqual(left, right);
                }
            }
            return !local.isDirty();
        }
    }

    class SVNLocalResourceNode
    extends ResourceNode {
        private final ISVNLocalResource svnResource;
        private ArrayList fChildren = null;

        public SVNLocalResourceNode(ISVNLocalResource svnResource) {
            super(svnResource.getIResource());
            this.svnResource = svnResource;
        }

        protected InputStream createStream() throws CoreException {
            return ((IFile)this.getResource()).getContents();
        }

        public ISVNLocalResource getLocalResource() {
            return this.svnResource;
        }

        public void setContent(byte[] contents) {
            if (contents == null) {
                contents = new byte[]{};
            }
            ByteArrayInputStream is = new ByteArrayInputStream(contents);
            IRunnableWithProgress runnable = new IRunnableWithProgress(this, is){
                final /* synthetic */ SVNLocalResourceNode this$1;
                private final /* synthetic */ InputStream val$is;
                {
                    this.this$1 = sVNLocalResourceNode;
                    this.val$is = inputStream;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        IFile file = (IFile)this.this$1.getResource();
                        if (this.val$is != null) {
                            if (!file.exists()) {
                                file.create(this.val$is, false, monitor);
                            } else {
                                file.setContents(this.val$is, false, true, monitor);
                            }
                        } else {
                            file.delete(false, true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(SVNLocalCompareInput.this.shell).run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                SVNUIPlugin.openError(SVNUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell(), Policy.bind("TeamFile.saveChanges", SVNLocalCompareInput.this.resource.getName()), null, e);
            }
            catch (InterruptedException interruptedException) {}
            this.fireContentChanged();
        }

        public Object[] getChildren() {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
                if (this.svnResource instanceof ISVNLocalFolder) {
                    try {
                        ISVNLocalResource[] members = (ISVNLocalResource[])((ISVNLocalFolder)this.svnResource).members(null, 59);
                        int i = 0;
                        while (i < members.length) {
                            IStructureComparator child = this.createChild(members[i]);
                            if (child != null) {
                                this.fChildren.add(child);
                            }
                            ++i;
                        }
                    }
                    catch (CoreException coreException) {}
                }
            }
            return this.fChildren.toArray();
        }

        protected IStructureComparator createChild(ISVNLocalResource child) {
            return new SVNLocalResourceNode(child);
        }

        public ITypedElement replace(ITypedElement child, ITypedElement other) {
            return null;
        }
    }
}

