/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.comments;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.comments.CommentTemplateEditDialog;

public class CommentTemplatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener {
    private ListViewer viewer;
    private Button editButton;
    private Button removeButton;
    private Text preview;

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createListAndButtons(parent);
        Label previewLabel = new Label(parent, 0);
        previewLabel.setText(Policy.bind("CommentTemplatesPreferencePage.Preview"));
        this.preview = new Text(parent, 2058);
        GridData gd = new GridData(768);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.preview.setLayoutData((Object)gd);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.tigris.subversion.subclipse.ui.comment_template_preference_page_context");
        Dialog.applyDialogFont((Control)ancestor);
        return parent;
    }

    private Composite createListAndButtons(Composite parent) {
        Composite listAndButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        listAndButtons.setLayout((Layout)layout);
        listAndButtons.setLayoutData((Object)new GridData(1808));
        this.viewer = new ListViewer(listAndButtons);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String template = (String)element;
                return Util.flattenText((String)template);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String template1 = Util.flattenText((String)((String)e1));
                String template2 = Util.flattenText((String)((String)e2));
                return template1.compareToIgnoreCase(template2);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CommentTemplatesPreferencePage.this.editTemplate();
            }
        });
        List list = this.viewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        String[] templates = SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().getCommentTemplates();
        int i = 0;
        while (i < templates.length) {
            this.viewer.add((Object)templates[i]);
            ++i;
        }
        this.createButtons(listAndButtons);
        return listAndButtons;
    }

    private void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button newButton = new Button(buttons, 8);
        newButton.setText(Policy.bind("CommentTemplatesPreferencePage.New"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, newButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        newButton.setLayoutData((Object)data);
        newButton.setEnabled(true);
        newButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CommentTemplatesPreferencePage.this.newTemplate();
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Policy.bind("CommentTemplatesPreferencePage.Edit"));
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.editButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommentTemplatesPreferencePage.this.editTemplate();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Policy.bind("CommentTemplatesPreferencePage.Remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommentTemplatesPreferencePage.this.remove();
            }
        });
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Policy.bind("CommentTemplatesPreferencePage.Description"));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        switch (selection.size()) {
            case 0: {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.preview.setText("");
                break;
            }
            case 1: {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.preview.setText((String)selection.getFirstElement());
                break;
            }
            default: {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(true);
                this.preview.setText("");
            }
        }
    }

    void newTemplate() {
        CommentTemplateEditDialog dialog = new CommentTemplateEditDialog(this.getShell(), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateTitle"), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateMessage"), "", null);
        if (dialog.open() == 0) {
            this.viewer.add((Object)dialog.getValue());
        }
    }

    void editTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            String oldTemplate = (String)selection.getFirstElement();
            CommentTemplateEditDialog dialog = new CommentTemplateEditDialog(this.getShell(), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateTitle"), Policy.bind("CommentTemplatesPreferencePage.EditCommentTemplateMessage"), oldTemplate, null);
            if (dialog.open() == 0) {
                this.viewer.remove((Object)oldTemplate);
                this.viewer.add((Object)dialog.getValue());
            }
        }
    }

    void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.viewer.remove(selection.toArray());
    }

    public boolean performOk() {
        int numTemplates = this.viewer.getList().getItemCount();
        String[] templates = new String[numTemplates];
        int i = 0;
        while (i < numTemplates) {
            templates[i] = (String)this.viewer.getElementAt(i);
            ++i;
        }
        try {
            SVNUIPlugin.getPlugin().getRepositoryManager().getCommentsManager().replaceAndSaveCommentTemplates(templates);
        }
        catch (TeamException e) {
            SVNUIPlugin.openError(this.getShell(), null, null, e, 8);
        }
        return super.performOk();
    }
}

