/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPage;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.ShowDifferencesAsUnifiedDiffDialogWC;

public class ShowDifferencesAsUnifiedDiffActionWC
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ShowDifferencesAsUnifiedDiffDialogWC dialog;
        IResource[] resources = this.getSelectedResources();
        if (resources.length > 0 && resources[0] instanceof IFile && !resources[0].isSynchronized(2) && MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("DifferencesDialog.compare"), (String)Policy.bind("CompareWithRemoteAction.fileChanged"))) {
            try {
                resources[0].refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        if ((dialog = new ShowDifferencesAsUnifiedDiffDialogWC(this.getShell(), resources[0], this.getTargetPart())).open() == 0 && !dialog.isDiffToOutputFile()) {
            try {
                if (resources[0] instanceof IContainer) {
                    RemoteFolder remoteFolder = new RemoteFolder(dialog.getSvnResource().getRepository(), dialog.getToUrl(), dialog.getToRevision());
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNLocalCompareInput(dialog.getSvnResource(), (ISVNRemoteResource)remoteFolder), (IWorkbenchPage)this.getTargetPage());
                } else {
                    RemoteFile remoteFile = new RemoteFile(dialog.getSvnResource().getRepository(), dialog.getToUrl(), dialog.getToRevision());
                    remoteFile.setPegRevision(dialog.getToRevision());
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)new SVNLocalCompareInput(dialog.getSvnResource(), (ISVNRemoteResource)remoteFile), (IWorkbenchPage)this.getTargetPage());
                }
            }
            catch (SVNException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("ShowDifferencesAsUnifiedDiffDialog.branchTag"), (String)e.getMessage());
            }
        }
    }

    protected boolean isEnabled() throws TeamException {
        return this.getSelectedResources().length == 1;
    }

    protected String getImageId() {
        return "Menu Compare";
    }
}

