/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class CopyAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IProject selectedProject;
        final IResource[] resources = this.getSelectedResources();
        IProject project = resources[0].getProject();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)project, false, Policy.bind("CopyAction.selectionLabel"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return;
        }
        Path path = (Path)result[0];
        File target = null;
        if (path.segmentCount() == 1) {
            selectedProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.toString());
            target = selectedProject.getLocation().toFile();
        } else {
            IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            selectedProject = targetFile.getProject();
            target = targetFile.getLocation().toFile();
        }
        final IProject targetProject = selectedProject;
        final File destPath = target;
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ISVNLocalResource svnTargetResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)targetProject);
                    ISVNClientAdapter client = null;
                    int i = 0;
                    while (i < resources.length) {
                        boolean sameRepository;
                        IResource resource = resources[i];
                        if (client == null) {
                            client = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]).getRepository().getSVNClient();
                        }
                        File checkFile = new File(String.valueOf(destPath.getPath()) + File.separator + resource.getName());
                        File srcPath = new File(resource.getLocation().toString());
                        File newDestPath = new File(String.valueOf(destPath.getPath()) + File.separator + resource.getName());
                        if (checkFile.exists()) {
                            IInputValidator inputValidator = new IInputValidator(this, resource){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ IResource val$resource;
                                {
                                    this.this$1 = var1_1;
                                    this.val$resource = iResource;
                                }

                                public String isValid(String newText) {
                                    if (newText.equals(this.val$resource.getName())) {
                                        return Policy.bind("CopyAction.nameConflictSame");
                                    }
                                    return null;
                                }
                            };
                            InputDialog inputDialog = new InputDialog(CopyAction.this.getShell(), Policy.bind("CopyAction.nameConflictTitle"), Policy.bind("CopyAction.nameConflictMessage", resource.getName()), "Copy of " + resource.getName(), inputValidator);
                            if (inputDialog.open() == 1) {
                                return;
                            }
                            String newName = inputDialog.getValue();
                            if (newName == null || newName.trim().length() == 0) {
                                return;
                            }
                            newDestPath = new File(String.valueOf(destPath.getPath()) + File.separator + newName);
                        }
                        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resource);
                        boolean bl = sameRepository = svnTargetResource != null && svnTargetResource.getRepository() != null && svnTargetResource.getRepository().getLocation().equals(svnResource.getRepository().getLocation());
                        if (sameRepository) {
                            client.copy(srcPath, newDestPath);
                        } else {
                            client.doExport(srcPath, newDestPath, true);
                        }
                        ++i;
                    }
                    targetProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)CopyAction.this.getShell(), (String)Policy.bind("CopyAction.copy"), (String)e.getMessage());
                }
            }
        });
    }

    protected boolean isEnabled() throws TeamException {
        boolean enabled = super.isEnabled();
        if (!enabled) {
            return false;
        }
        IResource[] resources = this.getSelectedResources();
        IProject project = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IProject) {
                return false;
            }
            if (project != null && !resources[i].getProject().equals((Object)project)) {
                return false;
            }
            project = resources[i].getProject();
            ++i;
        }
        return true;
    }

    protected String getImageId() {
        return "Menu Copy";
    }
}

