/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.script.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.Token;

public class CustomEndOfLineRule
extends PatternRule {
    private IToken successToken;
    private char startChar;

    public CustomEndOfLineRule(IToken successToken) {
        this(successToken, '\u0000');
    }

    public CustomEndOfLineRule(IToken successToken, char escapeCharacter) {
        super("1", "&", successToken, escapeCharacter, false, false);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        if (this.endSequenceDetected(scanner)) {
            return this.fToken;
        }
        return Token.UNDEFINED;
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (this.fEndSequence.length > 0 && c == this.fEndSequence[0]) {
                if (!this.sequenceDetected(scanner, this.fEndSequence, true)) continue;
                return false;
            }
            if (!this.fBreaksOnEOL) continue;
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], true)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        scanner.unread();
        return false;
    }
}

