/*
 * Decompiled with CFR 0.152.
 */
package com.something.eclipse.script.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class CaseInsensitiveWordRule
extends WordRule {
    private StringBuffer fBuffer = new StringBuffer();

    public CaseInsensitiveWordRule(IWordDetector detector) {
        this(detector, Token.UNDEFINED);
    }

    public CaseInsensitiveWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public void addWord(String word, IToken token) {
        super.addWord(word.toUpperCase(), token);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        char c = Character.toUpperCase((char)scanner.read());
        if (this.fDetector.isWordStart(c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append(c);
            } while ((c = Character.toUpperCase((char)scanner.read())) != '\uffffffff' && this.fDetector.isWordPart(c));
            scanner.unread();
            IToken token = (IToken)this.fWords.get(this.fBuffer.toString());
            if (token != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.fBuffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

